/*     */ package com.arjuna.ats.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.Inventory;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.Implementations;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.SyncFailedException;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class ObjectStore
/*     */ {
/*     */   public static final int OS_UNKNOWN = 0;
/*     */   public static final int OS_COMMITTED = 1;
/*     */   public static final int OS_UNCOMMITTED = 2;
/*     */   public static final int OS_HIDDEN = 4;
/*     */   public static final int OS_COMMITTED_HIDDEN = 5;
/*     */   public static final int OS_UNCOMMITTED_HIDDEN = 6;
/*     */   public static final int OS_SHADOW = 10;
/*     */   public static final int OS_ORIGINAL = 11;
/*     */   public static final int OS_INVISIBLE = 12;
/*     */   public static final int OS_SHARED = 13;
/*     */   public static final int OS_UNSHARED = 14;
/*     */   private ObjectStoreImple _imple;
/* 427 */   private static ClassName objectStoreType = null;
/*     */ 
/*     */   public ObjectStore()
/*     */   {
/*  87 */     this("", 14);
/*     */   }
/*     */ 
/*     */   public ObjectStore(int shareStatus)
/*     */   {
/*  92 */     this("", shareStatus);
/*     */   }
/*     */ 
/*     */   public ObjectStore(String location)
/*     */   {
/*  97 */     this(location, 14);
/*     */   }
/*     */ 
/*     */   public ObjectStore(String location, int shareStatus)
/*     */   {
/* 102 */     if (objectStoreType == null) {
/* 103 */       getDefault();
/*     */     }
/* 105 */     Object[] param = new Object[2];
/* 106 */     param[0] = location;
/* 107 */     param[1] = new Integer(shareStatus);
/*     */ 
/* 109 */     Object ptr = Inventory.inventory().createResources(objectStoreType, param);
/*     */ 
/* 111 */     param = null;
/*     */ 
/* 113 */     if ((ptr instanceof ObjectStoreImple))
/* 114 */       this._imple = ((ObjectStoreImple)ptr);
/*     */     else
/* 116 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public ObjectStore(ClassName typeName)
/*     */   {
/* 125 */     if (typeName == null) {
/* 126 */       typeName = getDefault();
/*     */     }
/* 128 */     Object ptr = Inventory.inventory().createVoid(typeName);
/*     */ 
/* 130 */     if ((ptr instanceof ObjectStoreImple))
/* 131 */       this._imple = ((ObjectStoreImple)ptr);
/*     */     else
/* 133 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public ObjectStore(ClassName typeName, int shareStatus)
/*     */   {
/* 138 */     this(typeName, "", shareStatus);
/*     */   }
/*     */ 
/*     */   public ObjectStore(ClassName typeName, String location)
/*     */   {
/* 143 */     this(typeName, location, 14);
/*     */   }
/*     */ 
/*     */   public ObjectStore(ClassName typeName, String location, int shareStatus)
/*     */   {
/* 148 */     if (typeName == null) {
/* 149 */       typeName = getDefault();
/*     */     }
/* 151 */     Object[] param = new Object[2];
/* 152 */     param[0] = location;
/* 153 */     param[1] = new Integer(shareStatus);
/*     */ 
/* 155 */     Object ptr = Inventory.inventory().createResources(typeName, param);
/*     */ 
/* 157 */     param = null;
/*     */ 
/* 159 */     if ((ptr instanceof ObjectStoreImple))
/* 160 */       this._imple = ((ObjectStoreImple)ptr);
/*     */     else
/* 162 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public ObjectStore(ClassName typeName, ObjectName objName)
/*     */   {
/* 167 */     if (typeName == null) {
/* 168 */       typeName = getDefault();
/*     */     }
/* 170 */     Object ptr = Inventory.inventory().createObjectName(typeName, objName);
/*     */ 
/* 172 */     if ((ptr instanceof ObjectStoreImple))
/* 173 */       this._imple = ((ObjectStoreImple)ptr);
/*     */     else
/* 175 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public ObjectStore(ObjectName objName)
/*     */   {
/* 180 */     ClassName typeName = null;
/*     */     try
/*     */     {
/* 184 */       typeName = objName.getClassNameAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreType");
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */ 
/* 190 */     if (typeName == null) {
/* 191 */       typeName = getDefault();
/*     */     }
/* 193 */     ObjectName osObjName = null;
/*     */     try
/*     */     {
/* 197 */       osObjName = objName.getObjectNameAttribute(ArjunaNames.ObjectStore_implementationObjectName());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */ 
/* 203 */     if (osObjName == null) {
/* 204 */       osObjName = objName;
/*     */     }
/* 206 */     Object ptr = Inventory.inventory().createObjectName(typeName, osObjName);
/*     */ 
/* 208 */     if ((ptr instanceof ObjectStoreImple))
/* 209 */       this._imple = ((ObjectStoreImple)ptr);
/*     */     else
/* 211 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 216 */     this._imple = null;
/*     */   }
/*     */ 
/*     */   public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException
/*     */   {
/* 221 */     return this._imple != null ? this._imple.allObjUids(s, buff, m) : false;
/*     */   }
/*     */ 
/*     */   public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException
/*     */   {
/* 226 */     return this._imple != null ? this._imple.allObjUids(s, buff, 0) : false;
/*     */   }
/*     */ 
/*     */   public boolean allTypes(InputObjectState buff) throws ObjectStoreException
/*     */   {
/* 231 */     return this._imple != null ? this._imple.allTypes(buff) : false;
/*     */   }
/*     */ 
/*     */   public int currentState(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 236 */     return this._imple != null ? this._imple.currentState(u, tn) : 0;
/*     */   }
/*     */ 
/*     */   public String getStoreName()
/*     */   {
/* 241 */     return this._imple != null ? this._imple.getStoreName() : null;
/*     */   }
/*     */ 
/*     */   public boolean commit_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 246 */     return this._imple != null ? this._imple.commit_state(u, tn) : false;
/*     */   }
/*     */ 
/*     */   public boolean hide_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 251 */     return this._imple != null ? this._imple.hide_state(u, tn) : false;
/*     */   }
/*     */ 
/*     */   public boolean reveal_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 256 */     return this._imple != null ? this._imple.reveal_state(u, tn) : false;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 261 */     return this._imple != null ? this._imple.read_committed(u, tn) : null;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 266 */     return this._imple != null ? this._imple.read_uncommitted(u, tn) : null;
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 271 */     return this._imple != null ? this._imple.remove_committed(u, tn) : false;
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 276 */     return this._imple != null ? this._imple.remove_uncommitted(u, tn) : false;
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException
/*     */   {
/* 281 */     return this._imple != null ? this._imple.write_committed(u, tn, buff) : false;
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException
/*     */   {
/* 286 */     return this._imple != null ? this._imple.write_uncommitted(u, tn, buff) : false;
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/* 291 */     return this._imple != null ? this._imple.typeIs() : -1;
/*     */   }
/*     */ 
/*     */   public void sync() throws SyncFailedException, ObjectStoreException
/*     */   {
/* 296 */     if (this._imple != null)
/* 297 */       this._imple.sync();
/*     */     else
/* 299 */       throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 304 */     return this._imple != null ? this._imple.className() : ClassName.invalid();
/*     */   }
/*     */ 
/*     */   public String locateStore(String location) throws ObjectStoreException
/*     */   {
/* 309 */     return this._imple != null ? this._imple.locateStore(location) : null;
/*     */   }
/*     */ 
/*     */   public boolean fullCommitNeeded()
/*     */   {
/* 314 */     return this._imple != null ? this._imple.fullCommitNeeded() : false;
/*     */   }
/*     */ 
/*     */   public boolean isType(Uid u, String tn, int st) throws ObjectStoreException
/*     */   {
/* 319 */     return this._imple != null ? this._imple.isType(u, tn, st) : false;
/*     */   }
/*     */ 
/*     */   public void initialise(Uid u, String tn)
/*     */   {
/* 324 */     if (this._imple != null)
/* 325 */       this._imple.initialise(u, tn);
/*     */   }
/*     */ 
/*     */   public void pack(OutputBuffer buff) throws IOException
/*     */   {
/* 330 */     if (this._imple != null)
/* 331 */       this._imple.pack(buff);
/*     */     else
/* 333 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
/*     */   }
/*     */ 
/*     */   public void unpack(InputBuffer buff) throws IOException
/*     */   {
/* 338 */     if (this._imple != null)
/* 339 */       this._imple.unpack(buff);
/*     */     else
/* 341 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
/*     */   }
/*     */ 
/*     */   public static void printStateStatus(PrintWriter strm, int res)
/*     */   {
/* 346 */     strm.print(stateStatusString(res));
/*     */   }
/*     */ 
/*     */   public static String stateStatusString(int res)
/*     */   {
/* 351 */     switch (res)
/*     */     {
/*     */     case 0:
/* 354 */       return "ObjectStore.OS_UNKNOWN";
/*     */     case 1:
/* 356 */       return "ObjectStore.OS_COMMITTED";
/*     */     case 2:
/* 358 */       return "ObjectStore.OS_UNCOMMITTED";
/*     */     case 4:
/* 360 */       return "ObjectStore.OS_HIDDEN";
/*     */     case 5:
/* 362 */       return "ObjectStore.OS_COMMITTED_HIDDEN";
/*     */     case 6:
/* 364 */       return "ObjectStore.OS_UNCOMMITTED_HIDDEN";
/*     */     case 3:
/* 366 */     }return "Unknown";
/*     */   }
/*     */ 
/*     */   public static void printStateType(PrintWriter strm, int res)
/*     */   {
/* 372 */     strm.print(stateTypeString(res));
/*     */   }
/*     */ 
/*     */   public static String stateTypeString(int res)
/*     */   {
/* 377 */     switch (res)
/*     */     {
/*     */     case 10:
/* 380 */       return "ObjectStore.OS_SHADOW";
/*     */     case 11:
/* 382 */       return "ObjectStore.OS_ORIGINAL";
/*     */     case 12:
/* 384 */       return "ObjectStore.OS_INVISIBLE";
/*     */     }
/* 386 */     return "Unknown";
/*     */   }
/*     */ 
/*     */   public final int shareState()
/*     */   {
/* 392 */     return this._imple != null ? this._imple.shareState() : -1;
/*     */   }
/*     */ 
/*     */   public final String storeDir()
/*     */   {
/* 397 */     return this._imple != null ? this._imple.storeDir() : null;
/*     */   }
/*     */ 
/*     */   public final String storeRoot()
/*     */   {
/* 402 */     return this._imple != null ? this._imple.storeRoot() : null;
/*     */   }
/*     */ 
/*     */   private ClassName getDefault()
/*     */   {
/* 419 */     if (objectStoreType == null) {
/* 420 */       objectStoreType = new ClassName(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreType", ArjunaNames.Implementation_ObjectStore_defaultStore().stringForm()));
/*     */     }
/* 422 */     return objectStoreType;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 431 */     if (!Implementations.added())
/* 432 */       Implementations.initialise();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.objectstore.ObjectStore
 * JD-Core Version:    0.6.0
 */