/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.recovery.TransactionStatusManager;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class TxControl
/*     */ {
/* 169 */   static boolean maintainHeuristics = true;
/*     */ 
/* 171 */   static boolean asyncCommit = false;
/*     */ 
/* 173 */   static boolean asyncPrepare = false;
/*     */ 
/* 175 */   static boolean asyncRollback = false;
/*     */ 
/* 177 */   static boolean onePhase = true;
/*     */ 
/* 179 */   static boolean readonlyOptimisation = true;
/*     */ 
/* 181 */   static boolean enableStatistics = false;
/*     */ 
/* 183 */   static boolean sharedTransactionLog = false;
/*     */ 
/* 185 */   static int numberOfTransactions = 100;
/*     */ 
/* 187 */   static boolean enable = true;
/*     */ 
/* 189 */   static TransactionStatusManager transactionStatusManager = null;
/*     */ 
/* 191 */   static ClassName actionStoreType = null;
/*     */ 
/* 193 */   static byte[] xaNodeName = null;
/*     */ 
/* 195 */   static int _defaultTimeout = 60;
/*     */ 
/*     */   public static final int getDefaultTimeout()
/*     */   {
/*  67 */     return _defaultTimeout;
/*     */   }
/*     */ 
/*     */   public static final void setDefaultTimeout(int timeout)
/*     */   {
/*  72 */     _defaultTimeout = timeout;
/*     */   }
/*     */ 
/*     */   public static final void enable()
/*     */   {
/*  77 */     enable = true;
/*     */   }
/*     */ 
/*     */   public static final void disable()
/*     */   {
/*  89 */     enable = false;
/*     */   }
/*     */ 
/*     */   public static final boolean isEnabled()
/*     */   {
/*  94 */     return enable;
/*     */   }
/*     */ 
/*     */   public static final ClassName getActionStoreType()
/*     */   {
/*  99 */     return actionStoreType;
/*     */   }
/*     */ 
/*     */   public static final ObjectStore getStore()
/*     */   {
/* 115 */     if (actionStoreType == null)
/*     */     {
/* 117 */       String useLog = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.transactionLog", "OFF");
/*     */ 
/* 120 */       if (useLog.equals("ON")) {
/* 121 */         actionStoreType = new ClassName(ArjunaNames.Implementation_ObjectStore_ActionLogStore());
/*     */       }
/*     */       else {
/* 124 */         actionStoreType = new ClassName(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.actionStore", ArjunaNames.Implementation_ObjectStore_defaultActionStore().stringForm()));
/*     */       }
/*     */ 
/* 132 */       String sharedLog = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.sharedTransactionLog", "NO");
/*     */ 
/* 135 */       if (sharedLog.equals("YES")) {
/* 136 */         sharedTransactionLog = true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 143 */     if (sharedTransactionLog) {
/* 144 */       return new ObjectStore(actionStoreType, 13);
/*     */     }
/* 146 */     return new ObjectStore(actionStoreType);
/*     */   }
/*     */ 
/*     */   public static final boolean getAsyncPrepare()
/*     */   {
/* 151 */     return asyncPrepare;
/*     */   }
/*     */ 
/*     */   public static final boolean getMaintainHeuristics()
/*     */   {
/* 156 */     return maintainHeuristics;
/*     */   }
/*     */ 
/*     */   public static final byte[] getXANodeName()
/*     */   {
/* 161 */     return xaNodeName;
/*     */   }
/*     */ 
/*     */   public static void setXANodeName(byte[] name)
/*     */   {
/* 166 */     xaNodeName = name;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 199 */     String env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.defaultTimeout");
/*     */ 
/* 202 */     if (env != null)
/*     */     {
/*     */       try
/*     */       {
/* 206 */         Integer in = new Integer(env);
/*     */ 
/* 208 */         _defaultTimeout = in.intValue();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 212 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 216 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.maintainHeuristics");
/*     */ 
/* 219 */     if (env != null)
/*     */     {
/* 221 */       if (env.compareTo("NO") == 0) {
/* 222 */         maintainHeuristics = false;
/*     */       }
/*     */     }
/* 225 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.asyncCommit");
/*     */ 
/* 228 */     if (env != null)
/*     */     {
/* 230 */       if (env.compareTo("YES") == 0) {
/* 231 */         asyncCommit = true;
/*     */       }
/*     */     }
/* 234 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.asyncPrepare");
/*     */ 
/* 237 */     if (env != null)
/*     */     {
/* 239 */       if (env.compareTo("YES") == 0) {
/* 240 */         asyncPrepare = true;
/*     */       }
/*     */     }
/* 243 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.commitOnePhase");
/*     */ 
/* 246 */     if (env != null)
/*     */     {
/* 248 */       if (env.compareTo("NO") == 0) {
/* 249 */         onePhase = false;
/*     */       }
/*     */     }
/* 252 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.asyncRollback");
/*     */ 
/* 255 */     if (env != null)
/*     */     {
/* 257 */       if (env.compareTo("YES") == 0) {
/* 258 */         asyncRollback = true;
/*     */       }
/*     */     }
/* 261 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.readonlyOptimisation");
/*     */ 
/* 264 */     if (env != null)
/*     */     {
/* 266 */       if (env.compareTo("NO") == 0) {
/* 267 */         readonlyOptimisation = false;
/*     */       }
/*     */     }
/* 270 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics");
/*     */ 
/* 273 */     if (env != null)
/*     */     {
/* 275 */       if (env.compareTo("YES") == 0) {
/* 276 */         enableStatistics = true;
/*     */       }
/*     */     }
/* 279 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.startDisabled");
/*     */ 
/* 282 */     if (env != null)
/*     */     {
/* 284 */       if (env.compareTo("YES") == 0) {
/* 285 */         enable = false;
/*     */       }
/*     */     }
/* 288 */     env = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.xa.nodeIdentifier");
/*     */ 
/* 290 */     boolean writeNodeName = false;
/*     */ 
/* 292 */     if (env != null)
/*     */     {
/* 294 */       xaNodeName = env.getBytes();
/*     */     }
/*     */     else
/*     */     {
/* 298 */       Uid nodeName = new Uid();
/*     */ 
/* 300 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 302 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_1", new Object[] { nodeName.stringForm() });
/*     */       }
/*     */ 
/* 308 */       xaNodeName = nodeName.stringForm().getBytes();
/*     */ 
/* 310 */       writeNodeName = true;
/*     */     }
/*     */ 
/* 313 */     if (xaNodeName.length > 30)
/*     */     {
/* 315 */       Uid nodeName = new Uid();
/*     */ 
/* 317 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 319 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_2", new Object[] { nodeName.stringForm() });
/*     */       }
/*     */ 
/* 325 */       xaNodeName = nodeName.stringForm().getBytes();
/*     */ 
/* 327 */       writeNodeName = true;
/*     */     }
/*     */ 
/* 330 */     if ((env != null) && (env.indexOf('-') != -1))
/*     */     {
/* 332 */       Uid nodeName = new Uid();
/*     */ 
/* 334 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 336 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_3", new Object[] { nodeName.stringForm() });
/*     */       }
/*     */ 
/* 342 */       xaNodeName = nodeName.stringForm().getBytes();
/*     */ 
/* 344 */       writeNodeName = true;
/*     */     }
/*     */ 
/* 347 */     if (writeNodeName)
/*     */     {
/* 349 */       arjPropertyManager.propertyManager.setProperty("com.arjuna.ats.arjuna.xa.nodeIdentifier", new String(xaNodeName));
/*     */     }
/*     */ 
/* 353 */     if (transactionStatusManager == null)
/*     */     {
/* 355 */       transactionStatusManager = new TransactionStatusManager();
/*     */ 
/* 358 */       Runtime.getRuntime().addShutdownHook(new Thread()
/*     */       {
/*     */         public void run()
/*     */         {
/* 362 */           if (TxControl.transactionStatusManager != null)
/*     */           {
/* 364 */             TxControl.transactionStatusManager.finalize();
/*     */           }
/*     */         }
/*     */       });
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.TxControl
 * JD-Core Version:    0.6.0
 */