/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.Iterator;
/*     */ import java.util.SortedSet;
/*     */ import java.util.Stack;
/*     */ import java.util.TreeSet;
/*     */ 
/*     */ public class TwoPhaseCoordinator extends BasicAction
/*     */   implements Reapable
/*     */ {
/*     */   private SortedSet _synchs;
/*     */   private SynchronizationRecord _currentRecord;
/*     */   private Throwable _deferredThrowable;
/*     */ 
/*     */   public TwoPhaseCoordinator()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TwoPhaseCoordinator(Uid id)
/*     */   {
/*  63 */     super(id);
/*     */   }
/*     */ 
/*     */   public int start()
/*     */   {
/*  68 */     return start(BasicAction.Current());
/*     */   }
/*     */ 
/*     */   public int start(BasicAction parentAction)
/*     */   {
/*  73 */     if (parentAction != null) {
/*  74 */       parentAction.addChildAction(this);
/*     */     }
/*  76 */     return super.Begin(parentAction);
/*     */   }
/*     */ 
/*     */   public int end(boolean report_heuristics)
/*     */   {
/*  83 */     if (parent() != null)
/*  84 */       parent().removeChildAction(this);
/*     */     int outcome;
/*     */     int outcome;
/*  86 */     if (beforeCompletion())
/*     */     {
/*  88 */       outcome = super.End(report_heuristics);
/*     */     }
/*     */     else {
/*  91 */       outcome = super.Abort();
/*     */     }
/*  93 */     afterCompletion(outcome);
/*     */ 
/*  95 */     return outcome;
/*     */   }
/*     */ 
/*     */   public int cancel()
/*     */   {
/* 100 */     if (TxControl.enableStatistics) {
/* 101 */       TxStats.incrementApplicationRollbacks();
/*     */     }
/* 103 */     if (parent() != null) {
/* 104 */       parent().removeChildAction(this);
/*     */     }
/*     */ 
/* 108 */     int outcome = super.Abort();
/*     */ 
/* 110 */     afterCompletion(outcome);
/*     */ 
/* 112 */     return outcome;
/*     */   }
/*     */ 
/*     */   public int addSynchronization(SynchronizationRecord sr)
/*     */   {
/* 117 */     if (sr == null) {
/* 118 */       return 3;
/*     */     }
/* 120 */     int result = 3;
/*     */ 
/* 122 */     if (parent() != null) {
/* 123 */       return 3;
/*     */     }
/* 125 */     switch (status())
/*     */     {
/*     */     case 0:
/* 129 */       synchronized (this)
/*     */       {
/* 131 */         if (this._synchs == null)
/*     */         {
/* 134 */           this._synchs = new TreeSet();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 142 */       if (((sr instanceof Comparable)) && (this._currentRecord != null)) {
/* 143 */         Comparable c = sr;
/* 144 */         if (c.compareTo(this._currentRecord) != 1) {
/* 145 */           return 3;
/*     */         }
/*     */       }
/*     */ 
/* 149 */       if (!this._synchs.add(sr))
/*     */         break;
/* 151 */       result = 2; break;
/*     */     }
/*     */ 
/* 159 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean running()
/*     */   {
/* 169 */     return status() == 0;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 178 */     return "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator";
/*     */   }
/*     */ 
/*     */   public Throwable getDeferredThrowable()
/*     */   {
/* 186 */     return this._deferredThrowable;
/*     */   }
/*     */ 
/*     */   protected TwoPhaseCoordinator(int at)
/*     */   {
/* 191 */     super(at);
/*     */   }
/*     */ 
/*     */   protected TwoPhaseCoordinator(Uid u, int at)
/*     */   {
/* 196 */     super(u, at);
/*     */   }
/*     */ 
/*     */   protected boolean beforeCompletion()
/*     */   {
/* 211 */     boolean problem = false;
/*     */ 
/* 217 */     if (this._synchs != null)
/*     */     {
/* 235 */       int lastIndexProcessed = -1;
/* 236 */       SynchronizationRecord[] copiedSynchs = (SynchronizationRecord[])(SynchronizationRecord[])this._synchs.toArray(new SynchronizationRecord[0]);
/*     */ 
/* 238 */       while ((lastIndexProcessed < this._synchs.size() - 1) && (!problem))
/*     */       {
/* 241 */         if (copiedSynchs.length != this._synchs.size()) {
/* 242 */           copiedSynchs = (SynchronizationRecord[])(SynchronizationRecord[])this._synchs.toArray(new SynchronizationRecord[0]);
/*     */         }
/*     */ 
/* 245 */         lastIndexProcessed += 1;
/* 246 */         this._currentRecord = copiedSynchs[lastIndexProcessed];
/*     */         try
/*     */         {
/* 250 */           problem = !this._currentRecord.beforeCompletion();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 259 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[] { this._currentRecord }, ex);
/*     */ 
/* 261 */           if (this._deferredThrowable == null) {
/* 262 */             this._deferredThrowable = ex;
/*     */           }
/* 264 */           problem = true;
/*     */         }
/*     */         catch (Error er)
/*     */         {
/* 268 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[] { this._currentRecord }, er);
/*     */ 
/* 270 */           if (this._deferredThrowable == null) {
/* 271 */             this._deferredThrowable = er;
/*     */           }
/* 273 */           problem = true;
/*     */         }
/*     */       }
/*     */ 
/* 277 */       if (problem)
/*     */       {
/* 279 */         if (!preventCommit())
/*     */         {
/* 286 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_1");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 291 */     return !problem;
/*     */   }
/*     */ 
/*     */   protected boolean afterCompletion(int myStatus)
/*     */   {
/* 313 */     if (myStatus == 0)
/*     */     {
/* 315 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_3");
/*     */ 
/* 317 */       return false;
/*     */     }
/*     */ 
/* 320 */     boolean problem = false;
/*     */ 
/* 322 */     if (this._synchs != null)
/*     */     {
/* 325 */       Stack stack = new Stack();
/* 326 */       Iterator iterator = this._synchs.iterator();
/* 327 */       while (iterator.hasNext()) {
/* 328 */         stack.push(iterator.next());
/*     */       }
/*     */ 
/* 331 */       iterator = stack.iterator();
/*     */ 
/* 337 */       while (!stack.isEmpty())
/*     */       {
/* 339 */         SynchronizationRecord record = (SynchronizationRecord)stack.pop();
/*     */         try
/*     */         {
/* 343 */           if (!record.afterCompletion(myStatus))
/*     */           {
/* 345 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4", new Object[] { record });
/*     */ 
/* 348 */             problem = true;
/*     */           }
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 353 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4a", new Object[] { record, ex });
/*     */ 
/* 355 */           problem = true;
/*     */         }
/*     */         catch (Error er)
/*     */         {
/* 359 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4b", new Object[] { record, er });
/*     */ 
/* 361 */           problem = true;
/*     */         }
/*     */       }
/*     */ 
/* 365 */       this._synchs = null;
/* 366 */       this._currentRecord = null;
/*     */     }
/*     */ 
/* 369 */     return !problem;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator
 * JD-Core Version:    0.6.0
 */