/*      */ package com.arjuna.ats.arjuna.coordinator;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*      */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*      */ import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
/*      */ import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
/*      */ import com.arjuna.ats.internal.arjuna.coordinator.ReaperWorkerThread;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.SortedSet;
/*      */ import java.util.TreeSet;
/*      */ 
/*      */ public class TransactionReaper
/*      */ {
/*      */   public static final String NORMAL = "NORMAL";
/*      */   public static final String DYNAMIC = "DYNAMIC";
/*      */   public static final long defaultCheckPeriod = 120000L;
/*      */   public static final long defaultCancelWaitPeriod = 500L;
/*      */   public static final long defaultCancelFailWaitPeriod = 500L;
/*      */   public static final int defaultZombieMax = 8;
/* 1116 */   private SortedSet _transactions = Collections.synchronizedSortedSet(new TreeSet());
/* 1117 */   private Map _timeouts = Collections.synchronizedMap(new HashMap());
/*      */ 
/* 1119 */   private List _workQueue = new LinkedList();
/*      */ 
/* 1121 */   private long _checkPeriod = 0L;
/*      */ 
/* 1128 */   private long _cancelWaitPeriod = 0L;
/*      */ 
/* 1135 */   private long _cancelFailWaitPeriod = 0L;
/*      */ 
/* 1141 */   private int _zombieMax = 0;
/*      */ 
/* 1143 */   private static TransactionReaper _theReaper = null;
/*      */ 
/* 1145 */   private static ReaperThread _reaperThread = null;
/*      */ 
/* 1147 */   private static ReaperWorkerThread _reaperWorkerThread = null;
/*      */ 
/* 1149 */   private static boolean _dynamic = false;
/*      */ 
/* 1151 */   private static long _lifetime = 0L;
/*      */ 
/* 1153 */   private static int _zombieCount = 0;
/*      */ 
/*      */   public TransactionReaper(long checkPeriod)
/*      */   {
/*  118 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  120 */       tsLogger.arjLogger.debug(1L, 4L, 1L, "TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
/*      */     }
/*      */ 
/*  126 */     this._checkPeriod = checkPeriod;
/*      */ 
/*  128 */     if (this._transactions == null)
/*      */     {
/*  130 */       if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*      */       {
/*  132 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1");
/*      */       }
/*      */ 
/*  136 */       throw new OutOfMemoryError();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void finalize()
/*      */   {
/*  142 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  144 */       tsLogger.arjLogger.debug(2L, 4L, 1L, "TransactionReaper.finalize ()");
/*      */     }
/*      */ 
/*  149 */     this._transactions = null;
/*      */   }
/*      */ 
/*      */   public final long checkingPeriod()
/*      */   {
/*  154 */     if (_dynamic)
/*      */     {
/*      */       try
/*      */       {
/*  158 */         ReaperElement head = (ReaperElement)this._transactions.first();
/*  159 */         return head._absoluteTimeout - System.currentTimeMillis();
/*      */       }
/*      */       catch (NoSuchElementException nsee)
/*      */       {
/*  163 */         return 9223372036854775807L;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  175 */       ReaperElement head = (ReaperElement)this._transactions.first();
/*  176 */       if (head._status != 0) {
/*  177 */         long waitTime = head._absoluteTimeout - System.currentTimeMillis();
/*  178 */         if (waitTime < this._checkPeriod)
/*      */         {
/*  180 */           return head._absoluteTimeout - System.currentTimeMillis();
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (NoSuchElementException nsee) {
/*      */     }
/*  186 */     return this._checkPeriod;
/*      */   }
/*      */ 
/*      */   public final boolean check()
/*      */   {
/*  202 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  204 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::check ()");
/*      */     }
/*      */ 
/*      */     while (true)
/*      */     {
/*      */       ReaperElement e;
/*      */       try
/*      */       {
/*  214 */         e = (ReaperElement)this._transactions.first();
/*      */       }
/*      */       catch (NoSuchElementException nsee)
/*      */       {
/*  218 */         return true;
/*      */       }
/*      */ 
/*  221 */       if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */       {
/*  223 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[] { Long.toString(e._absoluteTimeout) });
/*      */       }
/*      */ 
/*  233 */       long now = System.currentTimeMillis();
/*  234 */       if (now < e._absoluteTimeout)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  241 */       if (tsLogger.arjLogger.debugAllowed())
/*      */       {
/*  243 */         tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper timeout for TX " + e._control.get_uid() + " state " + e.statusName());
/*      */       }
/*      */ 
/*  256 */       synchronized (e) {
/*  257 */         switch (e._status)
/*      */         {
/*      */         case 0:
/*  267 */           e._status = 1;
/*      */ 
/*  269 */           synchronized (this)
/*      */           {
/*  271 */             this._transactions.remove(e);
/*      */ 
/*  273 */             e._absoluteTimeout = (System.currentTimeMillis() + this._cancelWaitPeriod);
/*      */ 
/*  275 */             this._transactions.add(e);
/*      */           }
/*      */ 
/*  278 */           if (tsLogger.arjLogger.debugAllowed())
/*      */           {
/*  280 */             tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper scheduling TX for cancellation " + e._control.get_uid());
/*      */           }
/*      */ 
/*  291 */           synchronized (this._workQueue)
/*      */           {
/*  293 */             this._workQueue.add(e);
/*  294 */             this._workQueue.notify();
/*      */           }
/*      */ 
/*  297 */           break;
/*      */         case 1:
/*  312 */           synchronized (this)
/*      */           {
/*  314 */             this._transactions.remove(e);
/*      */ 
/*  316 */             e._absoluteTimeout = (System.currentTimeMillis() + this._cancelWaitPeriod);
/*      */ 
/*  319 */             this._transactions.add(e);
/*      */           }
/*      */ 
/*  322 */           if (!tsLogger.arjLogger.debugAllowed())
/*      */             break;
/*  324 */           tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper deferring interrupt for TX scheduled for cancel " + e._control.get_uid()); break;
/*      */         case 2:
/*  340 */           e._status = 3;
/*      */ 
/*  342 */           e._worker.interrupt();
/*      */ 
/*  344 */           synchronized (this)
/*      */           {
/*  346 */             this._transactions.remove(e);
/*      */ 
/*  348 */             e._absoluteTimeout = (System.currentTimeMillis() + this._cancelFailWaitPeriod);
/*      */ 
/*  351 */             this._transactions.add(e);
/*      */           }
/*      */ 
/*  356 */           if (!tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */             break;
/*  358 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_4", new Object[] { e._control.get_uid() }); break;
/*      */         case 3:
/*  377 */           e._status = 6;
/*      */ 
/*  379 */           synchronized (this)
/*      */           {
/*  381 */             _zombieCount += 1;
/*      */ 
/*  383 */             if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */             {
/*  385 */               tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "Reaper " + Thread.currentThread() + " got a zombie " + e._worker + " (zombie count now " + _zombieCount + ") cancelling " + e._control.get_uid());
/*      */             }
/*      */ 
/*  392 */             if (_zombieCount == this._zombieMax)
/*      */             {
/*  396 */               if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */               {
/*  398 */                 tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_5", new Object[] { new Integer(_zombieCount) });
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  409 */           _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
/*  410 */           _reaperWorkerThread.setDaemon(true);
/*      */ 
/*  412 */           _reaperWorkerThread.start();
/*      */ 
/*  416 */           if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */           {
/*  418 */             tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_6", new Object[] { e._worker, e._control.get_uid() });
/*      */           }
/*      */ 
/*  434 */           synchronized (this)
/*      */           {
/*  436 */             this._timeouts.remove(e._control);
/*  437 */             this._transactions.remove(e);
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/*  442 */             if (e._control.preventCommit())
/*      */             {
/*  446 */               if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */               {
/*  448 */                 tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_10", new Object[] { e._control.get_uid() });
/*      */               }
/*      */ 
/*      */             }
/*  461 */             else if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */             {
/*  463 */               tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_11", new Object[] { e._control.get_uid() });
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (Exception e1)
/*      */           {
/*  476 */             if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
/*  477 */               tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_12", new Object[] { e._control.get_uid() });
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         case 4:
/*      */         case 5:
/*  497 */           synchronized (this)
/*      */           {
/*  499 */             this._timeouts.remove(e._control);
/*  500 */             this._transactions.remove(e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  509 */     return true;
/*      */   }
/*      */ 
/*      */   public final void waitForCancellations()
/*      */   {
/*  514 */     synchronized (this._workQueue)
/*      */     {
/*      */       try
/*      */       {
/*  518 */         while (this._workQueue.isEmpty())
/*      */         {
/*  520 */           this._workQueue.wait();
/*      */         }
/*      */       }
/*      */       catch (InterruptedException e)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void doCancellations()
/*      */   {
/*      */     while (true)
/*      */     {
/*      */       ReaperElement e;
/*  537 */       synchronized (this._workQueue)
/*      */       {
/*      */         try
/*      */         {
/*  541 */           e = (ReaperElement)this._workQueue.remove(0);
/*      */         } catch (IndexOutOfBoundsException ioobe) {
/*  543 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  551 */       if (tsLogger.arjLogger.debugAllowed())
/*      */       {
/*  553 */         tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper Worker " + Thread.currentThread() + " attempting to cancel " + e._control.get_uid());
/*      */       }
/*      */ 
/*  559 */       boolean cancelled = false;
/*  560 */       boolean excepted = false;
/*      */ 
/*  562 */       synchronized (e)
/*      */       {
/*  564 */         e._worker = Thread.currentThread();
/*  565 */         e._status = 2;
/*  566 */         e.notify();
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  575 */         if (e._control.running())
/*      */         {
/*  579 */           if (e._control.cancel() == 4)
/*      */           {
/*  581 */             cancelled = true;
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e1)
/*      */       {
/*  587 */         excepted = true;
/*      */       }
/*      */ 
/*  594 */       synchronized (e)
/*      */       {
/*  596 */         if (e._status == 6)
/*      */         {
/*  604 */           ReaperWorkerThread worker = (ReaperWorkerThread)Thread.currentThread();
/*  605 */           worker.shutdown();
/*      */ 
/*  607 */           synchronized (this)
/*      */           {
/*  609 */             _zombieCount -= 1;
/*      */           }
/*      */ 
/*  612 */           if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */           {
/*  614 */             tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_13", new Object[] { Thread.currentThread(), e._control.get_uid(), new Integer(_zombieCount) });
/*      */           }
/*      */ 
/*  629 */           break;
/*      */         }
/*  631 */         if ((cancelled) && (e._status == 3))
/*      */         {
/*  638 */           cancelled = false;
/*  639 */           e._status = 4;
/*  640 */           e.notify();
/*      */         }
/*      */         else
/*      */         {
/*  644 */           e._status = (cancelled ? 5 : 4);
/*      */ 
/*  647 */           e.notify();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  655 */       if (cancelled)
/*      */       {
/*  657 */         if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */         {
/*  659 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_7", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */         }
/*      */ 
/*  669 */         synchronized (this)
/*      */         {
/*  671 */           this._timeouts.remove(e._control);
/*  672 */           this._transactions.remove(e);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  677 */         if (excepted)
/*      */         {
/*  679 */           if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */           {
/*  681 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_9", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */           }
/*      */ 
/*      */         }
/*  693 */         else if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */         {
/*  695 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_8", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */         }
/*      */ 
/*  706 */         synchronized (this)
/*      */         {
/*  708 */           this._timeouts.remove(e._control);
/*  709 */           this._transactions.remove(e);
/*      */         }
/*      */ 
/*      */         try
/*      */         {
/*  714 */           if (e._control.preventCommit())
/*      */           {
/*  717 */             if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */             {
/*  719 */               tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_14", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */             }
/*      */ 
/*      */           }
/*  733 */           else if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*      */           {
/*  735 */             tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_15", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (Exception e1)
/*      */         {
/*  750 */           if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*  751 */             tsLogger.arjLoggerI18N.debug(1024L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_16", new Object[] { Thread.currentThread(), e._control.get_uid() });
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final long numberOfTransactions()
/*      */   {
/*  772 */     return this._transactions.size();
/*      */   }
/*      */ 
/*      */   public final long numberOfTimeouts()
/*      */   {
/*  781 */     return this._timeouts.size();
/*      */   }
/*      */ 
/*      */   public final boolean insert(Reapable control, int timeout)
/*      */   {
/*  790 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  792 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::insert ( " + control + ", " + timeout + " )");
/*      */     }
/*      */ 
/*  803 */     if (timeout == 0) {
/*  804 */       return true;
/*      */     }
/*      */ 
/*  810 */     if (this._timeouts.containsKey(control)) {
/*  811 */       return false;
/*      */     }
/*      */ 
/*  814 */     ReaperElement e = new ReaperElement(control, timeout);
/*      */ 
/*  816 */     synchronized (this)
/*      */     {
/*  818 */       _lifetime += timeout;
/*      */ 
/*  820 */       this._timeouts.put(control, e);
/*  821 */       boolean rtn = this._transactions.add(e);
/*      */ 
/*  823 */       if (_dynamic)
/*      */       {
/*  825 */         notify();
/*      */       }
/*      */ 
/*  828 */       return rtn;
/*      */     }
/*      */   }
/*      */ 
/*      */   public final boolean remove(Object control)
/*      */   {
/*  834 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  836 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::remove ( " + control + " )");
/*      */     }
/*      */ 
/*  841 */     if (control == null)
/*  842 */       return false;
/*      */     ReaperElement key;
/*  846 */     synchronized (this)
/*      */     {
/*  848 */       key = (ReaperElement)this._timeouts.remove(control);
/*  849 */       if (key == null) {
/*  850 */         return false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  862 */     synchronized (key)
/*      */     {
/*  864 */       if (key._status != 0)
/*      */       {
/*  870 */         return false;
/*      */       }
/*      */ 
/*  873 */       synchronized (this)
/*      */       {
/*      */       }
/*  876 */       monitorexit; throw localObject2;
/*      */     }
/*      */   }
/*      */ 
/*      */   public final int getTimeout(Object control)
/*      */   {
/*  889 */     if ((this._transactions.size() == 0) || (control == null))
/*      */     {
/*  891 */       if (tsLogger.arjLogger.debugAllowed())
/*      */       {
/*  893 */         tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getTimeout for " + control + " returning 0");
/*      */       }
/*      */ 
/*  900 */       return 0;
/*      */     }
/*      */ 
/*  903 */     ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
/*      */     Integer timeout;
/*      */     Integer timeout;
/*  906 */     if (reaperElement == null)
/*  907 */       timeout = new Integer(0);
/*      */     else {
/*  909 */       timeout = new Integer(reaperElement._timeout);
/*      */     }
/*      */ 
/*  912 */     tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[] { control, timeout });
/*      */ 
/*  921 */     return timeout.intValue();
/*      */   }
/*      */ 
/*      */   public static synchronized TransactionReaper create(long checkPeriod)
/*      */   {
/*  931 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  933 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::create ( " + checkPeriod + " )");
/*      */     }
/*      */ 
/*  938 */     if (_theReaper == null)
/*      */     {
/*  940 */       String mode = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperMode");
/*      */ 
/*  943 */       if (mode != null)
/*      */       {
/*  945 */         if (mode.compareTo("DYNAMIC") == 0) {
/*  946 */           _dynamic = true;
/*      */         }
/*      */       }
/*  949 */       if (!_dynamic)
/*      */       {
/*  951 */         String timeoutEnv = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperTimeout");
/*      */ 
/*  954 */         if (timeoutEnv != null)
/*      */         {
/*  956 */           Long l = null;
/*      */           try
/*      */           {
/*  960 */             l = new Long(timeoutEnv);
/*  961 */             checkPeriod = l.longValue();
/*      */ 
/*  963 */             l = null;
/*      */           }
/*      */           catch (NumberFormatException e)
/*      */           {
/*  967 */             tsLogger.arjLogger.warn("TransactionReaper::create - " + e);
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  973 */         checkPeriod = 9223372036854775807L;
/*      */       }
/*  975 */       _theReaper = new TransactionReaper(checkPeriod);
/*      */ 
/*  977 */       String cancelWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelWaitPeriod");
/*      */ 
/*  979 */       if (cancelWait != null)
/*      */       {
/*      */         try
/*      */         {
/*  983 */           _theReaper._cancelWaitPeriod = Long.valueOf(cancelWait).longValue();
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/*  987 */           _theReaper._cancelWaitPeriod = 500L;
/*      */         }
/*      */ 
/*  993 */         if (_theReaper._cancelWaitPeriod < 10L) {
/*  994 */           _theReaper._cancelWaitPeriod = 10L;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  999 */         _theReaper._cancelWaitPeriod = 500L;
/*      */       }
/*      */ 
/* 1002 */       String cancelFailWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelFailWaitPeriod");
/*      */ 
/* 1004 */       if (cancelFailWait != null)
/*      */       {
/*      */         try
/*      */         {
/* 1008 */           _theReaper._cancelFailWaitPeriod = Long.valueOf(cancelFailWait).longValue();
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/* 1012 */           _theReaper._cancelFailWaitPeriod = 500L;
/*      */         }
/*      */ 
/* 1018 */         if (_theReaper._cancelFailWaitPeriod < 10L) {
/* 1019 */           _theReaper._cancelFailWaitPeriod = 10L;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1024 */         _theReaper._cancelFailWaitPeriod = 500L;
/*      */       }
/*      */ 
/* 1027 */       String zombieMax = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperZombieMax");
/*      */ 
/* 1029 */       if (zombieMax != null)
/*      */       {
/*      */         try
/*      */         {
/* 1033 */           _theReaper._zombieMax = Integer.valueOf(zombieMax).intValue();
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/* 1037 */           _theReaper._zombieMax = 8;
/*      */         }
/*      */ 
/* 1043 */         if (_theReaper._zombieMax <= 0) {
/* 1044 */           _theReaper._zombieMax = 1;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1049 */         _theReaper._zombieMax = 8;
/*      */       }
/*      */ 
/* 1054 */       _theReaper._cancelWaitPeriod = 500L;
/* 1055 */       _theReaper._cancelFailWaitPeriod = 500L;
/* 1056 */       _theReaper._zombieMax = 8;
/*      */ 
/* 1058 */       _reaperThread = new ReaperThread(_theReaper);
/*      */ 
/* 1061 */       _reaperThread.setDaemon(true);
/*      */ 
/* 1063 */       _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
/* 1064 */       _reaperWorkerThread.setDaemon(true);
/*      */ 
/* 1066 */       _reaperThread.start();
/*      */ 
/* 1068 */       _reaperWorkerThread.start();
/*      */     }
/*      */ 
/* 1071 */     return _theReaper;
/*      */   }
/*      */ 
/*      */   public static TransactionReaper create()
/*      */   {
/* 1076 */     return create(120000L);
/*      */   }
/*      */ 
/*      */   public static TransactionReaper transactionReaper()
/*      */   {
/* 1081 */     return transactionReaper(false);
/*      */   }
/*      */ 
/*      */   public static synchronized TransactionReaper transactionReaper(boolean createReaper)
/*      */   {
/* 1091 */     if (createReaper) {
/* 1092 */       return create();
/*      */     }
/* 1094 */     return _theReaper;
/*      */   }
/*      */ 
/*      */   public static final synchronized long transactionLifetime()
/*      */   {
/* 1103 */     return _lifetime;
/*      */   }
/*      */ 
/*      */   static final void reset()
/*      */   {
/* 1113 */     _theReaper = null;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.TransactionReaper
 * JD-Core Version:    0.6.0
 */