/*     */ package com.arjuna.ats.arjuna.common;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class Mutex
/*     */ {
/*     */   public static final int LOCKED = 0;
/*     */   public static final int UNLOCKED = 1;
/*     */   public static final int WOULD_BLOCK = 2;
/*     */   public static final int ERROR = 3;
/*     */   private Object _lock;
/*     */   private int _users;
/*     */   private Thread _owner;
/*     */   private boolean _reentrant;
/*     */   private int _recursiveCalls;
/*     */ 
/*     */   public Mutex()
/*     */   {
/*  64 */     this(false);
/*     */   }
/*     */ 
/*     */   public Mutex(boolean reentrant)
/*     */   {
/*  69 */     this._lock = new Object();
/*  70 */     this._users = 0;
/*  71 */     this._owner = null;
/*  72 */     this._reentrant = reentrant;
/*  73 */     this._recursiveCalls = 0;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  78 */     if (this._users != 0)
/*     */     {
/*  80 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  81 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Mutex_1");
/*     */       }
/*     */     }
/*  84 */     synchronized (this._lock)
/*     */     {
/*  86 */       this._lock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int lock()
/*     */   {
/*  96 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  98 */       tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::lock()");
/*     */     }
/*     */ 
/* 102 */     synchronized (this._lock)
/*     */     {
/* 104 */       if (this._users == 0)
/*     */       {
/* 106 */         this._users = 1;
/*     */ 
/* 108 */         if (this._reentrant)
/*     */         {
/* 110 */           this._owner = Thread.currentThread();
/* 111 */           this._recursiveCalls = 1;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 116 */         boolean done = false;
/*     */ 
/* 118 */         if (this._reentrant)
/*     */         {
/* 120 */           if (this._owner == Thread.currentThread())
/*     */           {
/* 122 */             this._recursiveCalls += 1;
/*     */ 
/* 124 */             done = true;
/*     */           }
/*     */         }
/*     */ 
/* 128 */         if (!done)
/*     */         {
/* 130 */           this._users += 1;
/*     */           try
/*     */           {
/* 134 */             this._lock.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 143 */     return 0;
/*     */   }
/*     */ 
/*     */   public int unlock()
/*     */   {
/* 148 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 150 */       tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::unlock()");
/*     */     }
/*     */ 
/* 154 */     synchronized (this._lock)
/*     */     {
/* 156 */       if (this._users <= 0)
/*     */       {
/* 158 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 160 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Mutex_2");
/*     */         }
/*     */ 
/* 163 */         return 0;
/*     */       }
/*     */ 
/* 167 */       boolean done = false;
/*     */ 
/* 169 */       if (this._reentrant)
/*     */       {
/* 171 */         if (this._owner == Thread.currentThread())
/*     */         {
/* 173 */           if (--this._recursiveCalls == 0) {
/* 174 */             this._owner = null;
/*     */           }
/* 176 */           done = true;
/*     */         }
/*     */         else
/*     */         {
/* 180 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 182 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Mutex_2");
/*     */           }
/*     */ 
/* 185 */           return 0;
/*     */         }
/*     */       }
/*     */ 
/* 189 */       if (!done)
/*     */       {
/* 191 */         if (--this._users >= 0)
/*     */         {
/* 193 */           this._lock.notify();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 199 */     return 1;
/*     */   }
/*     */ 
/*     */   public int tryLock()
/*     */   {
/* 204 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 206 */       tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::tryLock()");
/*     */     }
/*     */ 
/* 211 */     synchronized (this._lock)
/*     */     {
/* 213 */       if (this._users == 0) {
/* 214 */         return lock();
/*     */       }
/*     */ 
/* 217 */       if (this._reentrant)
/*     */       {
/* 219 */         if (this._owner == Thread.currentThread()) {
/* 220 */           return lock();
/*     */         }
/*     */       }
/* 223 */       return 2;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.common.Mutex
 * JD-Core Version:    0.6.0
 */