/*      */ package com.arjuna.ats.arjuna;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.common.Mutex;
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*      */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*      */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*      */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*      */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*      */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*      */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.ats.arjuna.utils.Utility;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.ResourceBundle;
/*      */ 
/*      */ public class StateManager
/*      */ {
/*      */   protected StateManagerAttribute smAttributes;
/*      */   protected ObjectName objectName;
/*      */   protected Hashtable modifyingActions;
/*      */   protected Hashtable usingActions;
/*      */   protected Uid objectUid;
/*      */   private boolean activated;
/*      */   private boolean currentlyActivated;
/*      */   private int currentStatus;
/*      */   private int initialStatus;
/*      */   private int myType;
/*      */   private ObjectStore objectStore;
/*      */   private String storeRoot;
/* 1589 */   private Mutex mutex = new Mutex();
/*      */   private static final String marker = "#ARJUNA#";
/*      */ 
/*      */   public boolean save_state(OutputObjectState os, int ot)
/*      */   {
/*   99 */     if (ot == 1)
/*      */     {
/*      */       try
/*      */       {
/*  103 */         BasicAction action = BasicAction.Current();
/*      */ 
/*  105 */         if (action == null)
/*  106 */           packHeader(os, null, Utility.getProcessUid());
/*      */         else
/*  108 */           packHeader(os, action.get_uid(), Utility.getProcessUid());
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  112 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  116 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean restore_state(InputObjectState os, int ot)
/*      */   {
/*  131 */     if (ot == 1)
/*      */     {
/*      */       try
/*      */       {
/*  135 */         Uid txId = new Uid(Uid.nullUid());
/*  136 */         Uid processUid = new Uid(Uid.nullUid());
/*      */ 
/*  138 */         unpackHeader(os, txId, processUid);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  142 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  146 */     return true;
/*      */   }
/*      */ 
/*      */   public void finalize()
/*      */     throws Throwable
/*      */   {
/*  155 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  157 */       tsLogger.arjLogger.debug(2L, 4L, 32L, "StateManager.finalize() for object-id " + get_uid());
/*      */     }
/*      */ 
/*  161 */     if (this.currentStatus == 3)
/*      */     {
/*  163 */       BasicAction action = BasicAction.Current();
/*      */ 
/*  165 */       if ((action != null) && (action.status() == 0))
/*      */       {
/*  167 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*  168 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_1");
/*  169 */         cleanup(false);
/*      */       }
/*      */     }
/*      */ 
/*  173 */     this.smAttributes = null;
/*  174 */     this.objectName = null;
/*      */ 
/*  176 */     this.modifyingActions = null;
/*  177 */     this.usingActions = null;
/*      */ 
/*  179 */     this.objectStore = null;
/*  180 */     this.storeRoot = null;
/*  181 */     this.objectUid = null;
/*      */   }
/*      */ 
/*      */   public boolean activate()
/*      */   {
/*  207 */     return activate(null);
/*      */   }
/*      */ 
/*      */   public synchronized boolean activate(String rootName)
/*      */   {
/*  231 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  233 */       tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::activate( " + (rootName != null ? rootName : "null") + ") for object-id " + this.objectUid);
/*      */     }
/*      */ 
/*  237 */     if (this.myType == 2)
/*      */     {
/*  239 */       return true;
/*      */     }
/*      */ 
/*  242 */     if (this.currentStatus == 4) {
/*  243 */       return false;
/*      */     }
/*  245 */     BasicAction action = null;
/*  246 */     int oldStatus = this.currentStatus;
/*  247 */     boolean result = true;
/*  248 */     boolean forceAR = false;
/*      */ 
/*  258 */     action = BasicAction.Current();
/*      */ 
/*  260 */     if ((action != null) && (action.status() == 0))
/*      */     {
/*  274 */       synchronized (this.usingActions)
/*      */       {
/*  276 */         if (this.usingActions.get(action.topLevelAction().get_uid()) == null)
/*      */         {
/*  278 */           this.usingActions.put(action.topLevelAction().get_uid(), action.topLevelAction());
/*  279 */           forceAR = true;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  284 */     if ((forceAR) || (this.currentStatus == 0) || (this.currentStatus == 1))
/*      */     {
/*  292 */       if (loadObjectState())
/*      */       {
/*  294 */         setupStore(rootName);
/*      */       }
/*      */ 
/*  299 */       if (this.currentStatus == 0)
/*      */       {
/*  308 */         if (loadObjectState())
/*      */         {
/*  310 */           InputObjectState oldState = null;
/*      */           try
/*      */           {
/*  314 */             oldState = this.objectStore.read_committed(this.objectUid, type());
/*      */           }
/*      */           catch (ObjectStoreException e)
/*      */           {
/*  318 */             oldState = null;
/*      */           }
/*      */ 
/*  321 */           if (oldState != null)
/*      */           {
/*  323 */             if ((result = restore_state(oldState, 1)))
/*      */             {
/*  325 */               this.currentStatus = 2;
/*      */             }
/*      */ 
/*  328 */             oldState = null;
/*      */           }
/*      */           else
/*      */           {
/*  332 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */             {
/*  334 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_2", new Object[] { this.objectUid, type() });
/*      */             }
/*      */ 
/*  338 */             return false;
/*      */           }
/*      */ 
/*      */         }
/*  343 */         else if (this.currentStatus == 1) {
/*  344 */           this.currentStatus = 3;
/*      */         } else {
/*  346 */           this.currentStatus = 2;
/*      */         }
/*      */ 
/*      */       }
/*  351 */       else if (this.currentStatus == 1)
/*  352 */         this.currentStatus = 3;
/*      */       else {
/*  354 */         this.currentStatus = 2;
/*      */       }
/*      */ 
/*  362 */       if ((forceAR) || (((this.currentStatus == 2) || (this.currentStatus == 1)) && (action != null)))
/*      */       {
/*  365 */         int arStatus = 2;
/*  366 */         ActivationRecord ar = new ActivationRecord(oldStatus, this, action.topLevelAction());
/*      */ 
/*  368 */         if ((arStatus = action.add(ar)) != 2)
/*      */         {
/*  370 */           ar = null;
/*      */ 
/*  372 */           if (forceAR)
/*      */           {
/*  374 */             synchronized (this.usingActions)
/*      */             {
/*  376 */               this.usingActions.remove(action.topLevelAction().get_uid());
/*      */             }
/*      */           }
/*      */ 
/*  380 */           if (arStatus == 3) {
/*  381 */             result = false;
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  390 */           this.currentlyActivated = (this.activated = 1);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  395 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean deactivate()
/*      */   {
/*  412 */     return deactivate(null, true);
/*      */   }
/*      */ 
/*      */   public boolean deactivate(String rootName)
/*      */   {
/*  428 */     return deactivate(rootName, true);
/*      */   }
/*      */ 
/*      */   public synchronized boolean deactivate(String rootName, boolean commit)
/*      */   {
/*  442 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  444 */       tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::deactivate(" + (rootName != null ? rootName : "null") + ", " + commit + ") for object-id " + this.objectUid);
/*      */     }
/*      */ 
/*  448 */     boolean result = false;
/*      */ 
/*  450 */     if (((this.currentlyActivated) && (this.myType == 1)) || (loadObjectState()))
/*      */     {
/*  452 */       setupStore(rootName);
/*      */ 
/*  454 */       if ((this.currentStatus == 3) || (this.currentStatus == 2))
/*      */       {
/*  456 */         String tn = type();
/*  457 */         OutputObjectState newState = new OutputObjectState(this.objectUid, tn);
/*      */ 
/*  464 */         if (save_state(newState, this.myType))
/*      */         {
/*      */           try
/*      */           {
/*  468 */             if (commit)
/*  469 */               result = this.objectStore.write_committed(this.objectUid, tn, newState);
/*      */             else
/*  471 */               result = this.objectStore.write_uncommitted(this.objectUid, tn, newState);
/*      */           }
/*      */           catch (ObjectStoreException e)
/*      */           {
/*  475 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  476 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_3", e);
/*      */             }
/*  478 */             result = false;
/*      */           }
/*      */ 
/*      */         }
/*  483 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  484 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_4");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  499 */       result = true;
/*      */     }
/*      */ 
/*  502 */     return result;
/*      */   }
/*      */ 
/*      */   public synchronized int status()
/*      */   {
/*  511 */     return this.currentStatus;
/*      */   }
/*      */ 
/*      */   public synchronized int ObjectType()
/*      */   {
/*  520 */     return this.myType;
/*      */   }
/*      */ 
/*      */   public final Uid get_uid()
/*      */   {
/*  529 */     return this.objectUid;
/*      */   }
/*      */ 
/*      */   public synchronized boolean destroy()
/*      */   {
/*  544 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  546 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 32L, "com.arjuna.ats.arjuna.StateManager_5", new Object[] { this.objectUid });
/*      */     }
/*      */ 
/*  551 */     boolean result = false;
/*      */ 
/*  553 */     if (this.objectStore != null)
/*      */     {
/*  555 */       BasicAction action = BasicAction.Current();
/*      */ 
/*  557 */       if (action != null)
/*      */       {
/*  559 */         DisposeRecord dr = new DisposeRecord(this.objectStore, this);
/*      */ 
/*  561 */         if (action.add(dr) != 2)
/*      */         {
/*  563 */           dr = null;
/*      */ 
/*  565 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  567 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_6");
/*      */           }
/*      */         }
/*      */         else {
/*  571 */           result = true;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*      */         try {
/*  577 */           result = this.objectStore.remove_committed(get_uid(), type());
/*      */ 
/*  583 */           if (result)
/*  584 */             destroyed();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  588 */           if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  589 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_7", e);
/*      */           }
/*  591 */           result = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*  601 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */     {
/*  603 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_8");
/*      */     }
/*      */ 
/*  607 */     return result;
/*      */   }
/*      */ 
/*      */   public synchronized void disable()
/*      */   {
/*  619 */     this.myType = 2;
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter strm)
/*      */   {
/*  628 */     strm.println("Uid: " + this.objectUid);
/*  629 */     strm.println("Type: " + type());
/*      */   }
/*      */ 
/*      */   public String type()
/*      */   {
/*  641 */     return "/StateManager";
/*      */   }
/*      */ 
/*      */   public final String getStoreRoot()
/*      */   {
/*  651 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  653 */       tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::getStoreRoot ()");
/*      */     }
/*      */ 
/*  657 */     return this.storeRoot;
/*      */   }
/*      */ 
/*      */   public ObjectStore getStore()
/*      */   {
/*  667 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  669 */       tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::getStore ()");
/*      */     }
/*      */ 
/*  673 */     if (this.objectStore == null) {
/*  674 */       setupStore();
/*      */     }
/*  676 */     return this.objectStore;
/*      */   }
/*      */ 
/*      */   public Object attributes()
/*      */   {
/*  685 */     return this.smAttributes;
/*      */   }
/*      */ 
/*      */   protected void packHeader(OutputObjectState os, Uid txId, Uid processUid)
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/*  706 */       os.packString("#ARJUNA#");
/*      */ 
/*  714 */       if (txId != null)
/*      */       {
/*  716 */         txId.pack(os);
/*  717 */         processUid.pack(os);
/*      */       }
/*      */       else {
/*  720 */         Uid.nullUid().pack(os);
/*      */       }
/*      */     }
/*      */     catch (IOException ex) {
/*  724 */       throw ex;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  728 */       throw new IOException(e.toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void unpackHeader(InputObjectState os, Uid txId, Uid processUid)
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/*  747 */       String myState = os.unpackString();
/*      */ 
/*  749 */       if (myState.equals("#ARJUNA#"))
/*      */       {
/*  751 */         txId.unpack(os);
/*      */ 
/*  757 */         if (!txId.equals(Uid.nullUid()))
/*  758 */           processUid.unpack(os);
/*      */       }
/*      */       else
/*      */       {
/*  762 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  764 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_9");
/*      */         }
/*      */ 
/*  767 */         throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.StateManager_15"));
/*      */       }
/*      */     }
/*      */     catch (IOException ex)
/*      */     {
/*  772 */       throw ex;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  776 */       throw new IOException(e.toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void terminate()
/*      */   {
/*  787 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  789 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::terminate() for object-id " + get_uid());
/*      */     }
/*      */ 
/*  794 */     cleanup(true);
/*      */   }
/*      */ 
/*      */   protected final synchronized void setStatus(int s)
/*      */   {
/*  799 */     this.currentStatus = s;
/*      */   }
/*      */ 
/*      */   protected StateManager(Uid objUid)
/*      */   {
/*  811 */     this(objUid, 1, null);
/*      */   }
/*      */ 
/*      */   protected StateManager(Uid objUid, ObjectName attr)
/*      */   {
/*  816 */     this(objUid, 1, attr);
/*      */   }
/*      */ 
/*      */   protected StateManager(Uid objUid, int ot)
/*      */   {
/*  821 */     this(objUid, ot, null);
/*      */   }
/*      */ 
/*      */   protected StateManager(Uid objUid, int ot, ObjectName objName)
/*      */   {
/*  826 */     this.objectName = objName;
/*      */ 
/*  828 */     parseObjectName();
/*      */ 
/*  830 */     if (ot == 2)
/*      */     {
/*  832 */       this.modifyingActions = null;
/*  833 */       this.usingActions = null;
/*      */     }
/*      */     else
/*      */     {
/*  837 */       this.modifyingActions = new Hashtable();
/*  838 */       this.usingActions = new Hashtable();
/*      */     }
/*      */ 
/*  841 */     this.activated = false;
/*  842 */     this.currentlyActivated = false;
/*  843 */     this.currentStatus = 0;
/*  844 */     this.initialStatus = 0;
/*  845 */     this.myType = ot;
/*  846 */     this.objectStore = null;
/*  847 */     this.storeRoot = null;
/*      */ 
/*  849 */     this.objectUid = objUid;
/*      */ 
/*  851 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  853 */       tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + get_uid() + " )");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected StateManager()
/*      */   {
/*  860 */     this(0, null);
/*      */   }
/*      */ 
/*      */   protected StateManager(int ot)
/*      */   {
/*  865 */     this(ot, null);
/*      */   }
/*      */ 
/*      */   protected StateManager(int ot, ObjectName objName)
/*      */   {
/*  870 */     this.objectName = objName;
/*      */ 
/*  872 */     parseObjectName();
/*      */ 
/*  874 */     if (ot == 2)
/*      */     {
/*  876 */       this.modifyingActions = null;
/*  877 */       this.usingActions = null;
/*      */     }
/*      */     else
/*      */     {
/*  881 */       this.modifyingActions = new Hashtable();
/*  882 */       this.usingActions = new Hashtable();
/*      */     }
/*      */ 
/*  885 */     this.activated = false;
/*  886 */     this.currentlyActivated = false;
/*  887 */     this.currentStatus = ((this.smAttributes.objectModel == 0) && (ot == 0) ? 2 : 1);
/*  888 */     this.initialStatus = this.currentStatus;
/*  889 */     this.myType = ot;
/*  890 */     this.objectStore = null;
/*  891 */     this.storeRoot = null;
/*      */ 
/*  893 */     this.objectUid = new Uid();
/*      */ 
/*  895 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  897 */       tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + ot + " )");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected StateManager(ObjectName objName)
/*      */   {
/*  904 */     this.objectName = objName;
/*      */ 
/*  906 */     parseObjectName();
/*      */ 
/*  908 */     if (this.myType == 2)
/*      */     {
/*  910 */       this.modifyingActions = null;
/*  911 */       this.usingActions = null;
/*      */     }
/*      */     else
/*      */     {
/*  915 */       this.modifyingActions = new Hashtable();
/*  916 */       this.usingActions = new Hashtable();
/*      */     }
/*      */ 
/*  919 */     this.activated = false;
/*  920 */     this.currentlyActivated = false;
/*  921 */     this.currentStatus = 0;
/*  922 */     this.initialStatus = 0;
/*  923 */     this.objectStore = null;
/*  924 */     this.storeRoot = null;
/*      */ 
/*  926 */     if (this.objectUid == null) {
/*  927 */       this.objectUid = new Uid();
/*      */     }
/*  929 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  931 */       tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + objName + " )");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected synchronized boolean modified()
/*      */   {
/*  950 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  952 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::modified() for object-id " + get_uid());
/*      */     }
/*      */ 
/*  956 */     BasicAction action = BasicAction.Current();
/*  957 */     RecoveryRecord record = null;
/*      */ 
/*  959 */     if ((this.myType == 2) || (this.currentStatus == 4))
/*      */     {
/*  961 */       return true;
/*      */     }
/*      */ 
/*  964 */     if (this.currentStatus == 0)
/*      */     {
/*  966 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*  967 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_10");
/*  968 */       activate();
/*      */     }
/*      */ 
/*  975 */     if (this.currentStatus == 1) {
/*  976 */       this.currentStatus = 3;
/*      */     }
/*  978 */     if (action != null)
/*      */     {
/*  986 */       synchronized (this.modifyingActions)
/*      */       {
/*  988 */         if ((this.modifyingActions.size() > 0) && (this.modifyingActions.get(action.get_uid()) != null))
/*      */         {
/*  991 */           return true;
/*      */         }
/*      */ 
/*  994 */         this.modifyingActions.put(action.get_uid(), action);
/*      */       }
/*      */ 
/*  999 */       OutputObjectState state = new OutputObjectState(this.objectUid, type());
/* 1000 */       int rStatus = 2;
/*      */ 
/* 1002 */       if (save_state(state, 0))
/*      */       {
/* 1004 */         if ((this.myType == 0) && (this.smAttributes.objectModel == 0))
/*      */         {
/* 1006 */           record = new RecoveryRecord(state, this);
/*      */         }
/*      */         else {
/* 1009 */           record = new PersistenceRecord(state, this.objectStore, this);
/*      */         }
/* 1011 */         if ((rStatus = action.add(record)) != 2)
/*      */         {
/* 1013 */           synchronized (this.modifyingActions)
/*      */           {
/* 1015 */             this.modifyingActions.remove(action.get_uid());
/*      */           }
/*      */ 
/* 1018 */           record = null;
/*      */ 
/* 1020 */           return false;
/*      */         }
/*      */       }
/*      */       else {
/* 1024 */         return false;
/*      */       }
/*      */     }
/* 1027 */     return true;
/*      */   }
/*      */ 
/*      */   protected final synchronized void persist()
/*      */   {
/* 1041 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1043 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::persist() for object-id " + get_uid());
/*      */     }
/*      */ 
/* 1047 */     if (this.currentStatus == 2)
/*      */     {
/* 1049 */       this.currentStatus = 1;
/* 1050 */       this.myType = 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected final synchronized void cleanup(boolean fromTerminate)
/*      */   {
/* 1066 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1068 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::cleanup() for object-id " + get_uid());
/*      */     }
/*      */ 
/* 1072 */     if (this.myType == 2) {
/* 1073 */       return;
/*      */     }
/* 1075 */     BasicAction action = null;
/*      */ 
/* 1077 */     synchronized (this.usingActions)
/*      */     {
/* 1079 */       if (this.usingActions != null)
/*      */       {
/* 1081 */         Enumeration e = this.usingActions.keys();
/*      */ 
/* 1083 */         while (e.hasMoreElements())
/*      */         {
/* 1085 */           action = (BasicAction)this.usingActions.remove(e.nextElement());
/*      */ 
/* 1087 */           if (action == null)
/*      */           {
/*      */             continue;
/*      */           }
/*      */ 
/* 1096 */           AbstractRecord record = null;
/* 1097 */           int rStatus = 2;
/*      */ 
/* 1099 */           if ((this.currentStatus == 3) || (this.currentStatus == 2))
/*      */           {
/* 1102 */             OutputObjectState state = null;
/*      */ 
/* 1104 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */             {
/* 1106 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_11", new Object[] { this.objectUid, type() });
/*      */             }
/*      */ 
/* 1115 */             if (fromTerminate)
/*      */             {
/* 1117 */               state = new OutputObjectState(this.objectUid, type());
/*      */ 
/* 1119 */               if (!save_state(state, this.myType))
/*      */               {
/* 1121 */                 if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1122 */                   tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_12");
/*      */                 }
/*      */ 
/* 1125 */                 action.preventCommit();
/*      */               }
/*      */ 
/*      */             }
/*      */             else
/*      */             {
/* 1132 */               action.preventCommit();
/*      */             }
/*      */ 
/* 1140 */             setupStore(this.storeRoot);
/*      */ 
/* 1142 */             record = new CadaverRecord(state, this.objectStore, this);
/*      */ 
/* 1144 */             if ((rStatus = action.add(record)) != 2) {
/* 1145 */               record = null;
/*      */             }
/*      */           }
/* 1148 */           if ((this.currentlyActivated) && (this.currentStatus != 4))
/*      */           {
/* 1150 */             record = new CadaverActivationRecord(this);
/*      */ 
/* 1152 */             if ((rStatus = action.add(record)) == 2)
/*      */             {
/* 1154 */               this.currentStatus = 0;
/*      */             }
/*      */             else {
/* 1157 */               record = null;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1173 */     if (this.currentStatus == 3)
/*      */     {
/* 1175 */       if ((this.myType == 0) && (this.smAttributes.objectModel == 0))
/*      */       {
/* 1177 */         this.currentStatus = 2;
/*      */       }
/*      */       else
/*      */       {
/* 1181 */         this.currentStatus = 0;
/*      */       }
/*      */     }
/*      */ 
/* 1185 */     this.currentlyActivated = false;
/*      */   }
/*      */ 
/*      */   protected final void setupStore()
/*      */   {
/* 1195 */     setupStore(null);
/*      */   }
/*      */ 
/*      */   protected synchronized void setupStore(String rootName)
/*      */   {
/* 1206 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1208 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::setupStore ( " + (rootName != null ? rootName : "null") + " )");
/*      */     }
/*      */ 
/* 1212 */     if (!loadObjectState()) {
/* 1213 */       return;
/*      */     }
/*      */ 
/* 1220 */     if (this.objectStore != null) {
/* 1221 */       return;
/*      */     }
/* 1223 */     if (rootName == null)
/*      */     {
/* 1225 */       if (this.smAttributes.objectStoreRoot != null)
/*      */       {
/* 1227 */         rootName = this.smAttributes.objectStoreRoot;
/*      */       }
/*      */       else
/*      */       {
/* 1231 */         rootName = "";
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1237 */     if (this.storeRoot != null)
/*      */     {
/* 1241 */       if ((rootName == null) || (rootName.compareTo("") == 0) || (rootName.compareTo(this.storeRoot) == 0))
/*      */       {
/* 1244 */         return;
/*      */       }
/*      */ 
/* 1249 */       this.objectStore = null;
/*      */     }
/*      */ 
/* 1252 */     if (rootName == null)
/*      */     {
/* 1254 */       rootName = "";
/*      */     }
/*      */ 
/* 1259 */     this.storeRoot = new String(rootName);
/*      */ 
/* 1261 */     if ((this.myType == 1) || (this.myType == 2))
/*      */     {
/* 1268 */       int sharedStatus = this.smAttributes.objectModel == 0 ? 14 : 13;
/* 1269 */       ObjectName osObjName = null;
/*      */ 
/* 1271 */       if (this.objectName != null)
/*      */       {
/*      */         try
/*      */         {
/* 1275 */           osObjName = this.objectName.getObjectNameAttribute(ArjunaNames.ObjectStore_implementationObjectName());
/*      */         }
/*      */         catch (Exception ex)
/*      */         {
/* 1279 */           osObjName = null;
/*      */         }
/*      */       }
/*      */ 
/* 1283 */       if (osObjName == null)
/*      */       {
/* 1285 */         this.objectStore = new ObjectStore(this.smAttributes.objectStoreType, this.storeRoot, sharedStatus);
/*      */       }
/*      */       else
/*      */       {
/* 1289 */         this.objectStore = new ObjectStore(this.smAttributes.objectStoreType, osObjName);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1301 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1302 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_13");
/*      */       }
/* 1304 */       throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.StateManager_14"));
/*      */     }
/*      */ 
/* 1315 */     this.objectStore.initialise(get_uid(), type());
/*      */   }
/*      */ 
/*      */   protected final boolean loadObjectState()
/*      */   {
/* 1327 */     boolean load = this.smAttributes.objectModel != 0;
/*      */ 
/* 1335 */     if (!load)
/*      */     {
/* 1342 */       if ((this.myType != 0) && (!this.activated)) {
/* 1343 */         load = true;
/*      */       }
/*      */     }
/* 1346 */     return load;
/*      */   }
/*      */ 
/*      */   protected final synchronized boolean forgetAction(BasicAction action, boolean committed, int recordType)
/*      */   {
/* 1364 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1366 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::forgetAction(" + (action != null ? action.get_uid() : Uid.nullUid()) + ")" + " for object-id " + this.objectUid);
/*      */     }
/*      */ 
/* 1372 */     synchronized (this.modifyingActions)
/*      */     {
/* 1374 */       this.modifyingActions.remove(action.get_uid());
/*      */     }
/*      */ 
/* 1377 */     if (recordType != 101)
/*      */     {
/* 1379 */       synchronized (this.usingActions)
/*      */       {
/* 1381 */         if (this.usingActions != null)
/*      */         {
/* 1383 */           this.usingActions.remove(action.get_uid());
/*      */ 
/* 1385 */           if (this.usingActions.size() == 0)
/*      */           {
/* 1387 */             if (committed)
/*      */             {
/* 1389 */               if ((this.myType == 0) && (this.smAttributes.objectModel == 0))
/*      */               {
/* 1391 */                 this.initialStatus = (this.currentStatus = 2);
/*      */               }
/*      */               else
/*      */               {
/* 1395 */                 this.initialStatus = (this.currentStatus = 0);
/*      */               }
/*      */             }
/*      */             else {
/* 1399 */               this.currentStatus = this.initialStatus;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1405 */     return true;
/*      */   }
/*      */ 
/*      */   protected final synchronized boolean rememberAction(BasicAction action, int recordType)
/*      */   {
/* 1414 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1416 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::rememberAction(" + (action != null ? action.get_uid() : Uid.nullUid()) + ")" + " for object-id " + this.objectUid);
/*      */     }
/*      */ 
/* 1422 */     boolean result = false;
/*      */ 
/* 1424 */     if (recordType != 101)
/*      */     {
/* 1426 */       if ((action != null) && (action.status() == 0))
/*      */       {
/* 1428 */         synchronized (this.usingActions)
/*      */         {
/* 1430 */           if (this.usingActions.get(action.get_uid()) == null) {
/* 1431 */             this.usingActions.put(action.get_uid(), action);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1436 */     result = true;
/*      */ 
/* 1438 */     return result;
/*      */   }
/*      */ 
/*      */   protected final Mutex getMutex()
/*      */   {
/* 1449 */     return this.mutex;
/*      */   }
/*      */ 
/*      */   protected final boolean lockMutex()
/*      */   {
/* 1461 */     return this.mutex.lock() == 0;
/*      */   }
/*      */ 
/*      */   protected final boolean unlockMutex()
/*      */   {
/* 1475 */     return this.mutex.unlock() == 1;
/*      */   }
/*      */ 
/*      */   protected final boolean tryLockMutex()
/*      */   {
/* 1490 */     return this.mutex.tryLock() == 0;
/*      */   }
/*      */ 
/*      */   final synchronized void destroyed()
/*      */   {
/* 1506 */     this.currentStatus = 4;
/*      */   }
/*      */ 
/*      */   private void parseObjectName()
/*      */   {
/* 1515 */     this.smAttributes = new StateManagerAttribute();
/*      */ 
/* 1517 */     if (this.objectName != null)
/*      */     {
/*      */       try
/*      */       {
/* 1521 */         this.objectUid = this.objectName.getUidAttribute(ArjunaNames.StateManager_uid());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1527 */         this.objectUid = null;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1532 */         this.myType = (int)this.objectName.getLongAttribute(ArjunaNames.StateManager_objectType());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1536 */         this.myType = 1;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1541 */         this.smAttributes.objectModel = (int)this.objectName.getLongAttribute(ArjunaNames.StateManager_objectModel());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1554 */         this.smAttributes.objectStoreType = this.objectName.getClassNameAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreType");
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1563 */         this.smAttributes.objectStoreRoot = this.objectName.getStringAttribute(ArjunaNames.StateManager_objectStoreRoot());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1572 */       this.objectUid = null;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.StateManager
 * JD-Core Version:    0.6.0
 */