/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class LastResourceRecord extends AbstractRecord
/*     */ {
/*     */   private OnePhaseResource _lro;
/* 244 */   private static final Uid ONE_PHASE_RESOURCE_UID = Uid.lastResourceUid();
/*     */ 
/*     */   public LastResourceRecord(OnePhaseResource opr)
/*     */   {
/*  71 */     super(ONE_PHASE_RESOURCE_UID);
/*     */ 
/*  73 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  75 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "LastResourceRecord()");
/*     */     }
/*     */ 
/*  78 */     this._lro = opr;
/*     */   }
/*     */ 
/*     */   public boolean propagateOnCommit()
/*     */   {
/*  83 */     return false;
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  88 */     return 2147483647;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  93 */     return ArjunaNames.Implementation_AbstractRecord_LastResourceRecord();
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/*  98 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 100 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 104 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 109 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 111 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 115 */     return 8;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 124 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 126 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 130 */     return 1;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 135 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 137 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 141 */     if (this._lro != null)
/*     */     {
/* 143 */       return this._lro.rollback();
/*     */     }
/*     */ 
/* 147 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 153 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 155 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 159 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 164 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 166 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 170 */     if ((this._lro != null) && (this._lro.commit() == 7))
/*     */     {
/* 172 */       return 0;
/*     */     }
/*     */ 
/* 175 */     return 1;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 180 */     strm.println("LastResource for:");
/* 181 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 186 */     return "/StateManager/AbstractRecord/LastResourceRecord";
/*     */   }
/*     */ 
/*     */   public boolean shouldAdd(AbstractRecord a)
/*     */   {
/* 191 */     return a.typeIs() == typeIs();
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord a)
/*     */   {
/* 196 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord a)
/*     */   {
/* 201 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldAlter(AbstractRecord a)
/*     */   {
/* 206 */     return false;
/*     */   }
/*     */ 
/*     */   public void merge(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void alter(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object value()
/*     */   {
/* 223 */     return this._lro;
/*     */   }
/*     */ 
/*     */   public void setValue(Object o)
/*     */   {
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create()
/*     */   {
/* 232 */     return new LastResourceRecord();
/*     */   }
/*     */ 
/*     */   protected LastResourceRecord()
/*     */   {
/* 239 */     this._lro = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.LastResourceRecord
 * JD-Core Version:    0.6.0
 */