/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStoreType;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class DisposeRecord extends CadaverRecord
/*     */ {
/*     */   private Uid objectUid;
/*     */   private String typeName;
/*     */   private ObjectStore store;
/*     */ 
/*     */   public DisposeRecord(ObjectStore objStore, StateManager sm)
/*     */   {
/*  60 */     super(null, objStore, sm);
/*     */ 
/*  62 */     this.store = objStore;
/*     */ 
/*  64 */     if (sm != null)
/*     */     {
/*  66 */       this.objectUid = sm.get_uid();
/*  67 */       this.typeName = sm.type();
/*     */     }
/*     */     else
/*     */     {
/*  71 */       this.objectUid = Uid.nullUid();
/*  72 */       this.typeName = null;
/*     */     }
/*     */ 
/*  75 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  77 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "DisposeRecord::DisposeRecord(" + objStore + ", " + this.objectUid + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  85 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  87 */       tsLogger.arjLogger.debug(2L, 4L, 8L, "DisposeRecord.finalize for " + order());
/*     */     }
/*     */ 
/*  92 */     this.store = null;
/*  93 */     this.typeName = null;
/*     */ 
/*  95 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public boolean propagateOnAbort()
/*     */   {
/* 100 */     return false;
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/* 105 */     return 211;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 110 */     return ArjunaNames.Implementation_AbstractRecord_CadaverRecord_DisposeRecord();
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 115 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 117 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 121 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 126 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 128 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 132 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 137 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 139 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 143 */     if ((this.store != null) && (this.objectUid.notEquals(Uid.nullUid()))) {
/* 144 */       return 0;
/*     */     }
/* 146 */     return 1;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 151 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 153 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 157 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 168 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 170 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 174 */     if ((this.store != null) && (this.objectUid.notEquals(Uid.nullUid())))
/*     */     {
/*     */       try
/*     */       {
/* 178 */         if (this.store.remove_committed(this.objectUid, this.typeName))
/*     */         {
/* 182 */           if (this.objectAddr != null)
/*     */           {
/* 184 */             this.objectAddr.destroyed();
/*     */           }
/*     */ 
/* 187 */           return 7;
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 192 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 194 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_5", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 200 */     return 8;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 205 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 207 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 211 */     if ((this.store != null) && (this.objectUid.notEquals(Uid.nullUid())))
/*     */     {
/* 213 */       return 0;
/*     */     }
/*     */ 
/* 216 */     return 1;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 221 */     strm.println("Dispose for:");
/* 222 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public boolean doSave()
/*     */   {
/* 228 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, int ot)
/*     */   {
/* 240 */     boolean res = true;
/*     */ 
/* 242 */     if ((this.store != null) && (this.objectUid.notEquals(Uid.nullUid())))
/*     */     {
/* 244 */       if (!ObjectStoreType.valid(this.store.typeIs()))
/*     */       {
/* 246 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 247 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_1");
/*     */         }
/* 249 */         res = false;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 255 */           os.packInt(this.store.typeIs());
/* 256 */           this.store.pack(os);
/*     */ 
/* 258 */           this.objectUid.pack(os);
/* 259 */           os.packString(this.typeName);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 263 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 264 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_2");
/* 265 */           res = false;
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 271 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 272 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_3");
/*     */       }
/* 274 */       res = false;
/*     */     }
/*     */ 
/* 277 */     return res;
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int ot)
/*     */   {
/* 282 */     boolean res = true;
/* 283 */     int objStoreType = 0;
/*     */     try
/*     */     {
/* 287 */       objStoreType = os.unpackInt();
/*     */ 
/* 289 */       if (ObjectStoreType.valid(objStoreType))
/*     */       {
/* 291 */         this.store = null;
/*     */ 
/* 293 */         this.store = new ObjectStore(ObjectStoreType.typeToClassName(objStoreType));
/* 294 */         this.store.unpack(os);
/*     */ 
/* 296 */         this.objectUid.unpack(os);
/* 297 */         this.typeName = os.unpackString();
/*     */       }
/*     */       else
/*     */       {
/* 301 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 303 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_4", new Object[] { Integer.toString(objStoreType) });
/*     */         }
/*     */ 
/* 307 */         res = false;
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 312 */       res = false;
/*     */     }
/*     */ 
/* 315 */     return res;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 320 */     return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord/DisposeRecord";
/*     */   }
/*     */ 
/*     */   public boolean shouldAdd(AbstractRecord a)
/*     */   {
/* 325 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord a)
/*     */   {
/* 330 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord a)
/*     */   {
/* 335 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldAlter(AbstractRecord a)
/*     */   {
/* 340 */     return false;
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create()
/*     */   {
/* 345 */     return new DisposeRecord();
/*     */   }
/*     */ 
/*     */   protected DisposeRecord()
/*     */   {
/* 352 */     this.objectUid = new Uid(Uid.nullUid());
/* 353 */     this.typeName = null;
/* 354 */     this.store = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.DisposeRecord
 * JD-Core Version:    0.6.0
 */