/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ class ActivationRecord extends AbstractRecord
/*     */ {
/*     */   private StateManager objectAddr;
/*     */   private BasicAction actionHandle;
/*     */   private int state;
/*     */ 
/*     */   public ActivationRecord(int st, StateManager sm, BasicAction action)
/*     */   {
/*  60 */     super(sm.get_uid(), sm.type(), 1);
/*     */ 
/*  62 */     this.objectAddr = sm;
/*  63 */     this.actionHandle = action;
/*  64 */     this.state = st;
/*     */ 
/*  66 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  68 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "ActivationRecord::ActivationRecord(" + this.state + ", " + sm.get_uid() + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  76 */     return 131;
/*     */   }
/*     */ 
/*     */   public Object value()
/*     */   {
/*  81 */     return new Integer(this.state);
/*     */   }
/*     */ 
/*     */   public void setValue(Object v)
/*     */   {
/*  90 */     if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*  91 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.ActivationRecord_1");
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 101 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 103 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 107 */     int outcome = 8;
/*     */ 
/* 109 */     if ((this.objectAddr != null) && (this.actionHandle != null)) {
/* 110 */       outcome = this.objectAddr.forgetAction(this.actionHandle, false, 131) ? 7 : 8;
/*     */     }
/* 112 */     return outcome;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 124 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 126 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 130 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 135 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 137 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 141 */     return 2;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 151 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 153 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 157 */     return nestedAbort();
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 167 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 169 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 174 */     if ((this.objectAddr != null) && (this.actionHandle != null))
/*     */     {
/* 176 */       return this.objectAddr.forgetAction(this.actionHandle, true, 131) ? 7 : 8;
/*     */     }
/*     */ 
/* 179 */     return 8;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 184 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 186 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "ActivationRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 191 */     if (this.objectAddr == null) {
/* 192 */       return 1;
/*     */     }
/* 194 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int v)
/*     */   {
/* 206 */     if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */     {
/* 208 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.ActivationRecord_2", new Object[] { type(), order() });
/*     */     }
/*     */ 
/* 211 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, ObjectType v)
/*     */   {
/* 216 */     return true;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 221 */     super.print(strm);
/* 222 */     strm.println("ActivationRecord with state:\n" + this.state);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 227 */     return "/StateManager/AbstractRecord/ActivationRecord";
/*     */   }
/*     */ 
/*     */   public void merge(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void alter(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean shouldAdd(AbstractRecord a)
/*     */   {
/* 251 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldAlter(AbstractRecord a)
/*     */   {
/* 256 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord a)
/*     */   {
/* 261 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord a)
/*     */   {
/* 266 */     return false;
/*     */   }
/*     */ 
/*     */   protected ActivationRecord()
/*     */   {
/* 273 */     this.objectAddr = null;
/* 274 */     this.actionHandle = null;
/* 275 */     this.state = 0;
/*     */ 
/* 277 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 279 */       tsLogger.arjLogger.debug(1L, 2L, 8L, "ActivationRecord::ActivationRecord()");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.ActivationRecord
 * JD-Core Version:    0.6.0
 */