/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.GlobalCapabilitiesProvider;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.ModuleRegistry;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.logging.Logger;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoading {
    private static final Logger log = Logger.getLogger(ClassLoading.class);
    private Domain EMPTY_DOMAIN = new Domain(this, "DefaultDomain", null, true);
    private final Map<String, Domain> domains = new ConcurrentHashMap<String, Domain>();
    private final Set<GlobalCapabilitiesProvider> globalCapabilitiesProviders = new ConcurrentSet();
    private final Set<ModuleRegistry> moduleRegistries = new ConcurrentSet();

    public void addModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        String domainName = module.getDeterminedDomainName();
        boolean parentFirst = module.isJ2seClassLoadingCompliance();
        String parentDomainName = module.getDeterminedParentDomainName();
        Domain domain = this.getDomain(domainName, parentDomainName, parentFirst);
        domain.addModule(module);
        HashSet<ModuleRegistry> added = new HashSet<ModuleRegistry>();
        try {
            for (ModuleRegistry mr : this.moduleRegistries) {
                mr.addModule(module);
                added.add(mr);
            }
        }
        catch (Exception e) {
            for (ModuleRegistry mr : added) {
                try {
                    mr.removeModule(module);
                }
                catch (Exception ignored) {}
            }
            module.release();
            throw new IllegalArgumentException("Exception while registering Module.", e);
        }
    }

    public void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        for (ModuleRegistry mr : this.moduleRegistries) {
            try {
                mr.removeModule(module);
            }
            catch (Exception e) {
                log.warn((Object)("Exception unregistering module, registry: " + mr + ", cause: " + e));
            }
        }
        module.release();
    }

    public void addGlobalCapabilitiesProvider(GlobalCapabilitiesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null global capabilities provider");
        }
        this.globalCapabilitiesProviders.add(provider);
    }

    public void removeGlobalCapabilitiesProvider(GlobalCapabilitiesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null global capabilities provider");
        }
        this.globalCapabilitiesProviders.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Domain getDomain(String domainName, String parentDomainName, boolean parentFirst) {
        Domain domain;
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            domain = this.getDomain(domainName);
            if (domain == null) {
                domain = this.createDomain(domainName, parentDomainName, parentFirst);
                this.domains.put(domainName, domain);
            }
        }
        return domain;
    }

    protected Domain getDomain(String domainName) {
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        Domain domain = this.domains.get(domainName);
        if (domain == null && "DefaultDomain".equals(domainName)) {
            domain = this.EMPTY_DOMAIN;
        }
        return domain;
    }

    protected Domain createDomain(String domainName, String parentDomainName, boolean parentFirst) {
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        return new Domain(this, domainName, parentDomainName, parentFirst);
    }

    public static Module getModuleForClassLoader(ClassLoader loader) {
        return Module.getModuleForClassLoader(loader);
    }

    public static ClassLoader getClassLoaderForModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if (module == null) {
            return null;
        }
        return module.getClassLoader();
    }

    List<Capability> mergeGlobalCapabilities(List<Capability> capabilities) {
        if (capabilities == null) {
            throw new IllegalArgumentException("Null capabilities");
        }
        if (this.globalCapabilitiesProviders != null && this.globalCapabilitiesProviders.size() > 0) {
            for (GlobalCapabilitiesProvider provider : this.globalCapabilitiesProviders) {
                capabilities.addAll(provider.getCapabilities());
            }
        }
        return capabilities;
    }

    public boolean addModuleRegistry(ModuleRegistry moduleRegistry) {
        return this.moduleRegistries.add(moduleRegistry);
    }

    public boolean removeModuleRegistry(ModuleRegistry moduleRegistry) {
        return this.moduleRegistries.remove(moduleRegistry);
    }
}

