/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.vfs.policy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassFoundEvent;
import org.jboss.classloader.spi.ClassFoundHandler;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloading.plugins.vfs.PackageVisitor;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.policy.VirtualFileInfo;
import org.jboss.logging.Logger;
import org.jboss.util.collection.SoftValueHashMap;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoaderPolicy
extends ClassLoaderPolicy {
    private static Logger log = Logger.getLogger(VFSClassLoaderPolicy.class);
    private static final Manifest NO_MANIFEST = new Manifest();
    private String name;
    private List<? extends DelegateLoader> delegates;
    private VirtualFile[] roots;
    private VirtualFile[] excludedRoots;
    private ExportAll exportAll;
    private ClassFilter included;
    private ClassFilter excluded;
    private ClassFilter excludedExport;
    private String[] exportedPackages;
    private boolean importAll;
    private boolean cacheable = true;
    private boolean blackListable = true;
    private Map<String, Manifest> manifestCache = new ConcurrentHashMap<String, Manifest>();
    private Map<String, VirtualFileInfo> vfsCache = Collections.synchronizedMap(new SoftValueHashMap());

    private static String determineName(VirtualFile[] roots) {
        if (roots == null) {
            return "";
        }
        try {
            VirtualFile[] arr$ = roots;
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                VirtualFile root = arr$[i$];
                return root.toURL().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(VirtualFile ... roots) {
        return new VFSClassLoaderPolicy(roots);
    }

    public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(String name, VirtualFile ... roots) {
        return new VFSClassLoaderPolicy(name, roots);
    }

    public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(VirtualFile[] roots, VirtualFile[] excludedRoots) {
        return new VFSClassLoaderPolicy(roots, excludedRoots);
    }

    public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(String name, VirtualFile[] roots, VirtualFile[] excludedRoots) {
        return new VFSClassLoaderPolicy(name, roots, excludedRoots);
    }

    public VFSClassLoaderPolicy(VirtualFile[] roots) {
        this(VFSClassLoaderPolicy.determineName(roots), roots);
    }

    public VFSClassLoaderPolicy(VirtualFile[] roots, VirtualFile[] excludedRoots) {
        this(VFSClassLoaderPolicy.determineName(roots), roots, excludedRoots);
    }

    public VFSClassLoaderPolicy(String name, VirtualFile[] roots) {
        this(name, roots, null);
    }

    public VFSClassLoaderPolicy(String name, VirtualFile[] roots, VirtualFile[] excludedRoots) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (roots == null) {
            throw new IllegalArgumentException("Null roots");
        }
        for (VirtualFile root : roots) {
            if (root != null) continue;
            throw new IllegalArgumentException("Null root in " + Arrays.asList(roots));
        }
        if (excludedRoots != null) {
            for (VirtualFile excludedRoot : excludedRoots) {
                if (excludedRoot != null) continue;
                throw new IllegalArgumentException("Null excluded root in " + Arrays.asList(excludedRoots));
            }
        }
        this.name = name;
        this.roots = roots;
        this.excludedRoots = excludedRoots;
        this.addClassFoundHandler(new VFSCacheRemove());
    }

    public String getName() {
        return this.name;
    }

    public List<? extends DelegateLoader> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<? extends DelegateLoader> delegates) {
        this.delegates = delegates;
    }

    public ClassFilter getIncluded() {
        return this.included;
    }

    public void setIncluded(ClassFilter included) {
        this.included = included;
    }

    public ClassFilter getExcluded() {
        return this.excluded;
    }

    public void setExcluded(ClassFilter excluded) {
        this.excluded = excluded;
    }

    public ClassFilter getExcludedExport() {
        return this.excludedExport;
    }

    public void setExcludedExport(ClassFilter excludedExport) {
        this.excludedExport = excludedExport;
    }

    public ExportAll getExportAll() {
        return this.exportAll;
    }

    public void setExportAll(ExportAll exportAll) {
        this.exportAll = exportAll;
        if (exportAll != null && this.exportedPackages == null) {
            Set<String> exported = PackageVisitor.determineAllPackages(this.roots, this.excludedRoots, exportAll, this.included, this.excluded, this.excludedExport);
            this.exportedPackages = exported.toArray(new String[exported.size()]);
        }
    }

    public String[] getExportedPackages() {
        return this.exportedPackages;
    }

    public void setExportedPackages(String[] exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    public String[] getPackageNames() {
        return this.exportedPackages;
    }

    public boolean isImportAll() {
        return this.importAll;
    }

    public void setImportAll(boolean importAll) {
        this.importAll = importAll;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isBlackListable() {
        return this.blackListable;
    }

    public void setBlackListable(boolean blackListable) {
        this.blackListable = blackListable;
    }

    public DelegateLoader getExported() {
        if (this.getExportAll() != null) {
            return new FilteredDelegateLoader((ClassLoaderPolicy)this, ClassFilterUtils.EVERYTHING);
        }
        return super.getExported();
    }

    public URL getResource(String path) {
        if (this.checkFilters(path, "getResource")) {
            return null;
        }
        VirtualFile child = this.findChild(path);
        if (child != null) {
            try {
                return child.toURL();
            }
            catch (Exception ignored) {
                log.debug((Object)("Error determining URL for " + child), (Throwable)ignored);
                return null;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if (this.checkFilters(path, "getResourceAsStream")) {
            return null;
        }
        VirtualFile child = this.findChild(path);
        if (child != null) {
            try {
                return child.openStream();
            }
            catch (Exception ignored) {
                log.debug((Object)("Error opening stream for " + child), (Throwable)ignored);
                return null;
            }
        }
        return null;
    }

    public void getResources(String name, Set<URL> urls) throws IOException {
        if (this.checkFilters(name, "getResources")) {
            return;
        }
        for (VirtualFile root : this.roots) {
            try {
                VirtualFile child = root.getChild(name);
                if (!child.exists()) continue;
                urls.add(child.toURL());
            }
            catch (Exception e) {
                log.debug((Object)("Error getting resources for " + root), (Throwable)e);
            }
        }
    }

    protected VirtualFile findChild(String path) {
        VirtualFileInfo vfi = this.findVirtualFileInfo(path);
        if (vfi == null) {
            return null;
        }
        return vfi.getFile();
    }

    protected VirtualFile findRoot(String path) {
        VirtualFileInfo vfi = this.findVirtualFileInfo(path);
        if (vfi == null) {
            return null;
        }
        return vfi.getRoot();
    }

    protected VirtualFileInfo findVirtualFileInfo(String path) {
        VirtualFileInfo result = this.vfsCache.get(path);
        if (result != null) {
            return result;
        }
        for (VirtualFile root : this.roots) {
            try {
                VirtualFile file = root.getChild(path);
                if (!file.exists()) continue;
                result = new VirtualFileInfo(file, root);
                this.vfsCache.put(path, result);
                return result;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public PackageInformation getClassPackageInformation(String className, String packageName) {
        Manifest manifest;
        block7: {
            String path = ClassLoaderUtils.classNameToPath((String)className);
            VirtualFile root = this.findRoot(path);
            manifest = null;
            String rootURL = null;
            if (root != null) {
                try {
                    rootURL = root.toURL().toString();
                    manifest = this.manifestCache.get(rootURL);
                    if (manifest == null) {
                        manifest = VFSUtils.getManifest((VirtualFile)root);
                        if (manifest == null) {
                            this.manifestCache.put(rootURL, NO_MANIFEST);
                        } else {
                            this.manifestCache.put(rootURL, manifest);
                        }
                    }
                    if (manifest == NO_MANIFEST) {
                        manifest = null;
                    }
                }
                catch (Exception ignored) {
                    if (!log.isTraceEnabled()) break block7;
                    log.trace((Object)("Unable to retrieve manifest for " + path + " url=" + rootURL + " error=" + ignored.getMessage()));
                }
            }
        }
        return new PackageInformation(packageName, manifest);
    }

    protected void toLongString(StringBuilder builder) {
        builder.append(" roots=").append(Arrays.asList(this.roots)).append(" ");
        super.toLongString(builder);
        if (this.exportAll != null) {
            builder.append(this.exportAll);
        }
    }

    protected ProtectionDomain getProtectionDomain(String className, String path) {
        VirtualFile clazz = this.findChild(path);
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Unable to determine class file for " + className));
            }
            return null;
        }
        try {
            VirtualFile root = this.findRoot(path);
            URL codeSourceURL = root.toURL();
            if (log.isTraceEnabled()) {
                log.trace((Object)("getProtectionDomain:className=" + className + " path=" + path + " codeSourceURL=" + codeSourceURL));
            }
            CodeSigner[] signers = clazz.getCodeSigners();
            CodeSource cs = new CodeSource(codeSourceURL, signers);
            PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
            return new ProtectionDomain(cs, permissions);
        }
        catch (Exception e) {
            throw new Error("Error determining protection domain for " + clazz, e);
        }
    }

    protected boolean checkFilters(String path, String context) {
        if (this.included != null && !this.included.matchesResourcePath(path)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)((Object)((Object)this) + " " + context + " path=" + path + " doesn't match include filter: " + this.included));
            }
            return true;
        }
        if (this.excluded != null && this.excluded.matchesResourcePath(path)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)((Object)((Object)this) + " " + context + "  path=" + path + " matches exclude filter: " + this.excluded));
            }
            return true;
        }
        return false;
    }

    private class VFSCacheRemove
    implements ClassFoundHandler {
        private VFSCacheRemove() {
        }

        public void classFound(ClassFoundEvent event) {
            String className = event.getClassName();
            String path = ClassLoaderUtils.classNameToPath((String)className);
            VFSClassLoaderPolicy.this.vfsCache.remove(path);
        }
    }
}

