/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.resource;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.plugin.deployment.common.AbstractServerConnection;
import org.jboss.as.plugin.deployment.resource.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class AddResource
extends AbstractServerConnection {
    public static final String GOAL = "add-resource";
    public static final String PROFILE = "profile";
    private String address;
    private Map<String, String> properties;
    private Resource resource;
    private Resource[] resources;
    private boolean force;

    @Override
    public String goal() {
        return GOAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            InetAddress host = this.getHostAddress();
            this.getLog().info((CharSequence)String.format("Executing goal %s on server %s (%s) port %s.", this.goal(), host.getHostName(), host.getHostAddress(), this.getPort()));
            ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.getHostAddress(), (int)this.getPort(), (CallbackHandler)this.getCallbackHandler());
            try {
                if (this.resources == null) {
                    Resource resource = this.resource == null ? new Resource(this.address, this.properties, false) : this.resource;
                    this.processResources(client, resource);
                } else if (this.resources.length > 0) {
                    this.processResources(client, this.resources);
                } else {
                    this.getLog().warn((CharSequence)"No resources were provided.");
                }
            }
            finally {
                this.safeClose((Closeable)client);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    private void processResources(ModelControllerClient client, Resource ... resources) throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        op.get("rollback-on-runtime-failure").set(true);
        for (Resource resource : resources) {
            if (this.isDomainServer()) {
                List<String> profiles = this.getDomain().getProfiles();
                if (profiles.isEmpty()) {
                    throw new IllegalStateException("Cannot add resources when no profiles were defined.");
                }
                for (String profile : profiles) {
                    ModelNode model;
                    if (!this.addCompositeResource(profile, client, resource, this.address, model = new ModelNode(), true)) continue;
                    op.get("steps").set(model.get("steps"));
                    ModelNode r = client.execute(OperationBuilder.create((ModelNode)op).build());
                    this.reportFailure(r);
                }
                continue;
            }
            ModelNode model = new ModelNode();
            if (!this.addCompositeResource(null, client, resource, this.address, model, true)) continue;
            op.get("steps").set(model.get("steps"));
            ModelNode r = client.execute(OperationBuilder.create((ModelNode)op).build());
            this.reportFailure(r);
        }
    }

    private boolean addCompositeResource(String profileName, ModelControllerClient client, Resource resource, String parentAddress, ModelNode compositeOp, boolean checkExistence) throws IOException {
        ModelNode address = new ModelNode();
        if (parentAddress == null) {
            this.setupAddress(profileName, resource.getAddress(), address);
        } else if (parentAddress.equals(resource.getAddress())) {
            this.setupAddress(profileName, resource.getAddress(), address);
        } else if (resource.getAddress() == null) {
            this.setupAddress(profileName, parentAddress, address);
        } else {
            this.setupAddress(profileName, String.format("%s,%s", parentAddress, resource.getAddress()), address);
        }
        if (!address.isDefined()) {
            throw new RuntimeException("You must specify the address to deploy the resource to.");
        }
        if (checkExistence) {
            boolean exists = this.resourceExists(address, client);
            if (resource.isAddIfAbsent() && exists) {
                return false;
            }
            if (exists && this.force) {
                ModelNode r = client.execute(OperationBuilder.create((ModelNode)this.buildRemoveOperation(address)).build());
                this.reportFailure(r);
            } else if (exists && !this.force) {
                throw new RuntimeException("Resource " + address + " already exists.");
            }
        }
        compositeOp.get("steps").add(this.buildAddOperation(address, resource.getProperties()));
        if (resource.getResources() != null) {
            String resourceAddress = resource.getAddress();
            String addr = parentAddress != null && resourceAddress != null ? parentAddress + "," + resourceAddress : (parentAddress != null ? parentAddress : (resourceAddress != null ? resourceAddress : null));
            for (Resource r : resource.getResources()) {
                this.addCompositeResource(profileName, client, r, addr, compositeOp, false);
            }
        }
        if (resource.isEnableResource()) {
            compositeOp.get("steps").add(this.buildEnableOperation(address));
        }
        return true;
    }

    private ModelNode buildRemoveOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("recursive").set(true);
        op.get("address").set(address.get("address"));
        return op;
    }

    private ModelNode buildEnableOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("enable");
        op.get("address").set(address.get("address"));
        return op;
    }

    private ModelNode buildAddOperation(ModelNode address, Map<String, String> properties) {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(address.get("address"));
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            String value;
            String[] props = prop.getKey().split(",");
            if (props.length == 0) {
                throw new RuntimeException("Invalid property " + prop);
            }
            ModelNode node = op;
            for (int i = 0; i < props.length - 1; ++i) {
                node = node.get(props[i]);
            }
            String string = value = prop.getValue() == null ? "" : prop.getValue();
            if (value.startsWith("!!")) {
                this.handleDmrString(node, props[props.length - 1], value);
                continue;
            }
            node.get(props[props.length - 1]).set(value);
        }
        return op;
    }

    private boolean resourceExists(ModelNode address, ModelControllerClient client) throws IOException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        request.get("recursive").set(false);
        Property childAddress = this.setupParentAddress(address, request);
        ModelNode r = client.execute(new OperationBuilder(request).build());
        this.reportFailure(r);
        boolean found = false;
        String name = childAddress.getName();
        if (r.get("result").get(name).isDefined()) {
            for (ModelNode dataSource : r.get("result").get(name).asList()) {
                if (!dataSource.asProperty().getName().equals(childAddress.getValue().asString())) continue;
                found = true;
            }
        }
        return found;
    }

    private void handleDmrString(ModelNode node, String name, String value) {
        String realValue = value.substring(2);
        node.get(name).set(ModelNode.fromString((String)realValue));
    }

    private void setupAddress(String profileName, String inputAddress, ModelNode request) {
        if (inputAddress != null) {
            if (profileName != null) {
                request.get("address").add(PROFILE, profileName);
            }
            for (ModelNode part : this.parseAddressParts(inputAddress)) {
                request.get("address").add(part);
            }
        }
    }

    private List<ModelNode> parseAddressParts(String inputAddress) {
        String[] parts = inputAddress.split(",");
        ArrayList<ModelNode> result = new ArrayList<ModelNode>(parts.length);
        for (String part : parts) {
            String[] address = part.split("=");
            if (address.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            result.add(new ModelNode().set(address[0], address[1]));
        }
        return result;
    }

    private void reportFailure(ModelNode node) {
        if (!node.get("outcome").asString().equals("success")) {
            String msg = node.hasDefined("failure-description") ? (node.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", node.get("operation"), node.get("address"), node.get("failure-description")) : String.format("Operation failed: %s", node.get("failure-description"))) : String.format("Operation failed: %s", node);
            throw new RuntimeException(msg);
        }
    }

    private Property setupParentAddress(ModelNode address, ModelNode request) {
        if (address.isDefined()) {
            List addresses = address.get("address").asList();
            for (int i = 0; i < addresses.size() - 1; ++i) {
                request.get("address").add((ModelNode)addresses.get(i));
            }
            return ((ModelNode)addresses.get(addresses.size() - 1)).asProperty();
        }
        return null;
    }
}

