/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadPoolMetricsHandler;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class BoundedQueueThreadPoolMetricsHandler
extends ThreadPoolMetricsHandler {
    public static final List<AttributeDefinition> METRICS = Arrays.asList(PoolAttributeDefinitions.CURRENT_THREAD_COUNT, PoolAttributeDefinitions.LARGEST_THREAD_COUNT, PoolAttributeDefinitions.REJECTED_COUNT);

    public BoundedQueueThreadPoolMetricsHandler(ServiceName serviceNameBase) {
        super(METRICS, serviceNameBase);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        BoundedQueueThreadPoolService bounded = (BoundedQueueThreadPoolService)service;
        if (attributeName.equals("current-thread-count")) {
            context.getResult().set(bounded.getCurrentThreadCount());
        } else if (attributeName.equals("largest-thread-count")) {
            context.getResult().set(bounded.getLargestThreadCount());
        } else if (attributeName.equals("rejected-count")) {
            context.getResult().set(bounded.getRejectedCount());
        } else {
            throw ThreadsMessages.MESSAGES.unsupportedBoundedQueueThreadPoolMetric(attributeName);
        }
    }
}

