/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SpecifiedInterfaceResolveHandler
implements OperationStepHandler,
DescriptionProvider {
    static final AttributeDefinition[] ATTRIBUTES = InterfaceDescription.ROOT_ATTRIBUTES;
    public static final String OPERATION_NAME = "resolve-internet-address";
    public static final SpecifiedInterfaceResolveHandler INSTANCE = new SpecifiedInterfaceResolveHandler();

    private SpecifiedInterfaceResolveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode config = new ModelNode();
        for (AttributeDefinition definition : ATTRIBUTES) {
            this.validateAndSet(definition, operation, config);
        }
        ParsedInterfaceCriteria parsed = ParsedInterfaceCriteria.parse((ModelNode)config, (boolean)true, (OperationContext)context);
        if (parsed.getFailureMessage() != null) {
            throw new OperationFailedException(new ModelNode().set(parsed.getFailureMessage()));
        }
        try {
            NetworkInterfaceBinding nib = NetworkInterfaceService.createBinding(parsed);
            context.getResult().set(nib.getAddress().getHostAddress());
        }
        catch (SocketException e) {
            throw ServerMessages.MESSAGES.cannotResolveInterface(e, e);
        }
        catch (UnknownHostException e) {
            throw ServerMessages.MESSAGES.cannotResolveInterface(e, e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.required(attributeName)));
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalid(attributeName)));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceDescriptionResolver resolver = ServerDescriptions.getResourceDescriptionResolver("interface");
        DefaultOperationDescriptionProvider delegate = new DefaultOperationDescriptionProvider(OPERATION_NAME, resolver, ModelType.STRING, new AttributeDefinition[0]);
        ModelNode result = delegate.getModelDescription(locale);
        ModelNode toMerge = SpecifiedInterfaceAddHandler.INSTANCE.getModelDescription(locale);
        result.get("request-properties").set(toMerge.get("request-properties"));
        return result;
    }
}

