/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerDescriptions {
    private static final String RESOURCE_NAME = ServerDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, ServerDescriptions.class.getClassLoader(), true, true);
    }

    private ServerDescriptions() {
    }

    public static final ModelNode getRemoveDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = ServerDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("deployment.remove"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getServerReloadOperation(Locale locale) {
        ResourceBundle bundle2 = ServerDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamOnlyOperation((ResourceBundle)bundle2, (String)"reload", null, (String)"admin-only", (ModelType)ModelType.BOOLEAN, (boolean)true);
    }

    public static final ModelNode getSystemPropertyDescription(Locale locale) {
        ResourceBundle bundle2 = ServerDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle2.getString("server.system-property"), (boolean)false);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

