/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;

public class DeploymentDeployHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "deploy";
    public static final DeploymentDeployHandler INSTANCE = new DeploymentDeployHandler();

    static ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    private DeploymentDeployHandler() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getDeployDeploymentOperation((Locale)locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        model.get("enabled").set(true);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String runtimeName = model.require("runtime-name").asString();
        DeploymentHandlerUtil.ContentItem[] contents = AbstractDeploymentHandler.getContents(model.require("content"));
        DeploymentHandlerUtil.deploy(context, runtimeName, name, contents);
        context.completeStep();
    }
}

