/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.protocol.ProtocolLogger;

public final class StreamUtils {
    private static final int BUFFER_SIZE = 8192;

    private StreamUtils() {
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
    }

    public static void copyStream(InputStream in, DataOutput out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    public static void safeClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, socket);
            }
        }
    }

    public static void safeClose(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseServerSocket(e, serverSocket);
            }
        }
    }

    public static void safeClose(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, writer);
            }
        }
    }
}

