/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.IntegrationServices;
import org.osgi.framework.BundleException;

public class BundleInstallIntegration
implements BundleInstallHandler {
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private ServerDeploymentManager deploymentManager;
    private ServiceTarget serviceTarget;

    public static ServiceController<?> addService(ServiceTarget target) {
        BundleInstallIntegration service = new BundleInstallIntegration();
        ServiceBuilder builder = target.addService(IntegrationServices.BUNDLE_INSTALL_HANDLER, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedController);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    private BundleInstallIntegration() {
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedController.getValue());
        this.serviceTarget = context.getChildTarget();
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public BundleInstallHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installBundle(Deployment dep) throws BundleException {
        OSGiLogger.LOGGER.tracef("Install deployment: %s", dep);
        try {
            String contextName = DeploymentHolderService.getContextName(dep);
            DeploymentHolderService.addService(this.serviceTarget, contextName, dep);
            InputStream inputStream = dep.getRoot().openStream();
            try {
                InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
                builder = builder.add(contextName, inputStream).andDeploy();
                DeploymentPlan plan = builder.build();
                DeploymentAction deployAction = builder.getLastAction();
                this.executeDeploymentPlan(plan, deployAction);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        OSGiLogger.LOGGER.debugf(e, "Failed to close resource %s", inputStream);
                    }
                }
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (BundleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw OSGiMessages.MESSAGES.cannotDeployBundle(ex, dep);
        }
    }

    public void uninstallBundle(Deployment dep) {
        OSGiLogger.LOGGER.tracef("Uninstall deployment: %s", dep);
        try {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            String contextName = DeploymentHolderService.getContextName(dep);
            builder = builder.undeploy(contextName).remove(contextName);
            DeploymentPlan plan = builder.build();
            DeploymentAction removeAction = builder.getLastAction();
            this.executeDeploymentPlan(plan, removeAction);
        }
        catch (Exception ex) {
            OSGiLogger.LOGGER.warnCannotUndeployBundle(ex, dep);
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction action) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return action.getDeploymentUnitUniqueName();
    }
}

