/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ModuleIdentityArtifactProvider;
import org.jboss.as.osgi.service.RepositoryProvider;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallComplete;
import org.jboss.osgi.framework.AutoInstallHandler;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.StorageStateProvider;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XRequirementBuilder;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.repository.Repository;
import org.osgi.service.startlevel.StartLevel;

class AutoInstallIntegration
extends AbstractService<AutoInstallHandler>
implements AutoInstallHandler {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<StorageStateProvider> injectedStorageProvider = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<Repository> injectedRepository = new InjectedValue();
    private final InjectedValue<Bundle> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private File bundlesDir;

    static ServiceController<?> addService(ServiceTarget target) {
        AutoInstallIntegration service = new AutoInstallIntegration();
        ServiceBuilder builder = target.addService(IntegrationServices.AUTOINSTALL_HANDLER, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(RepositoryProvider.SERVICE_NAME, Repository.class, service.injectedRepository);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, service.injectedPackageAdmin);
        builder.addDependency(Services.STORAGE_STATE_PROVIDER, StorageStateProvider.class, service.injectedStorageProvider);
        builder.addDependency(Services.SYSTEM_BUNDLE, Bundle.class, service.injectedSystemBundle);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, service.injectedStartLevel);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    AutoInstallIntegration() {
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController serviceController = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", serviceController.getName(), serviceController.getMode());
        BundleContext syscontext = ((Bundle)this.injectedSystemBundle.getValue()).getBundleContext();
        String startLevelProp = syscontext.getProperty("org.osgi.framework.startlevel.beginning");
        int beginningStartLevel = startLevelProp != null ? Integer.parseInt(startLevelProp) : 1;
        try {
            ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
            this.bundlesDir = serverEnvironment.getBundlesDir();
            if (!this.bundlesDir.isDirectory()) {
                throw OSGiMessages.MESSAGES.illegalStateCannotFindBundleDir(this.bundlesDir);
            }
            final ArrayList<SubsystemState.OSGiCapability> configcaps = new ArrayList<SubsystemState.OSGiCapability>();
            configcaps.add(new SubsystemState.OSGiCapability("org.osgi.enterprise", null));
            configcaps.addAll(((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities());
            Iterator iterator = configcaps.iterator();
            while (iterator.hasNext()) {
                SubsystemState.OSGiCapability configcap = (SubsystemState.OSGiCapability)iterator.next();
                if (!this.installInitialModuleCapability(configcap)) continue;
                iterator.remove();
            }
            final LinkedHashSet<ServiceName> resolvableServices = new LinkedHashSet<ServiceName>();
            AutoInstallComplete installComplete = new AutoInstallComplete(){

                protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                    return configcaps.size() == trackedServices.size();
                }

                public void start(StartContext context) throws StartException {
                    LinkedHashSet<Bundle> resolvableBundles = new LinkedHashSet<Bundle>();
                    ServiceContainer serviceContainer = context.getController().getServiceContainer();
                    for (ServiceName serviceName : resolvableServices) {
                        ServiceController requiredService = serviceContainer.getRequiredService(serviceName);
                        resolvableBundles.add((Bundle)requiredService.getValue());
                    }
                    Bundle[] bundleArr = resolvableBundles.toArray(new Bundle[resolvableBundles.size()]);
                    PackageAdmin packageAdmin = (PackageAdmin)AutoInstallIntegration.this.injectedPackageAdmin.getValue();
                    packageAdmin.resolveBundles(bundleArr);
                    super.start(context);
                }
            };
            installComplete.install(context.getChildTarget());
            ServiceListener listener = installComplete.getListener();
            for (SubsystemState.OSGiCapability configcap : configcaps) {
                int startLevel;
                ServiceName serviceName = this.installInitialCapability(configcap, (ServiceListener<Bundle>)listener);
                int n = startLevel = configcap.getStartLevel() != null ? configcap.getStartLevel() : 1;
                if (serviceName == null || startLevel > beginningStartLevel) continue;
                resolvableServices.add(serviceName);
            }
        }
        catch (Exception ex) {
            throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapabilites(ex);
        }
    }

    private boolean installInitialModuleCapability(SubsystemState.OSGiCapability osgicap) throws Exception {
        ModuleIdentifier moduleId;
        File bundleFile;
        String identifier = osgicap.getIdentifier();
        if (this.isValidModuleIdentifier(identifier) && (bundleFile = ModuleIdentityArtifactProvider.getRepositoryEntry(this.bundlesDir, moduleId = ModuleIdentifier.fromString((String)identifier))) == null) {
            OSGiLogger.LOGGER.tracef("Installing initial module capability: %s", identifier);
            Module module = null;
            try {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                module = moduleLoader.loadModule(moduleId);
            }
            catch (ModuleLoadException ex) {
                throw OSGiMessages.MESSAGES.startFailedCannotResolveInitialCapability(ex, identifier);
            }
            if (module != null) {
                OSGiMetaData metadata = this.getModuleMetadata(module);
                XResourceBuilder builder = XResourceBuilderFactory.create();
                if (metadata != null) {
                    builder.loadFrom(metadata);
                } else {
                    builder.loadFrom(module);
                }
                XResource res = builder.getResource();
                res.addAttachment(Module.class, (Object)module);
                ((XEnvironment)this.injectedEnvironment.getValue()).installResources(new XResource[]{res});
                return true;
            }
        }
        return false;
    }

    private ServiceName installInitialCapability(SubsystemState.OSGiCapability osgicap, ServiceListener<Bundle> listener) throws Exception {
        String identifier = osgicap.getIdentifier();
        Integer level = osgicap.getStartLevel();
        ServiceName result = null;
        if (this.isValidModuleIdentifier(identifier)) {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
            File bundleFile = ModuleIdentityArtifactProvider.getRepositoryEntry(this.bundlesDir, moduleId);
            if (bundleFile != null) {
                OSGiLogger.LOGGER.tracef("Installing initial bundle capability: %s", identifier);
                URL bundleURL = bundleFile.toURI().toURL();
                result = this.installBundleFromURL(bundleURL, identifier, level, listener);
            }
        } else if (this.isValidMavenIdentifier(identifier)) {
            OSGiLogger.LOGGER.tracef("Installing initial maven capability: %s", identifier);
            Repository repository = (Repository)this.injectedRepository.getValue();
            MavenCoordinates mavenId = MavenCoordinates.parse((String)identifier);
            XRequirement req = XRequirementBuilder.createArtifactRequirement((MavenCoordinates)mavenId);
            Collection caps = (Collection)repository.findProviders(Collections.singleton(req)).get(req);
            if (!caps.isEmpty()) {
                XIdentityCapability icap = (XIdentityCapability)caps.iterator().next();
                URL bundleURL = (URL)icap.getAttribute("content.url");
                result = this.installBundleFromURL(bundleURL, identifier, level, listener);
            }
        }
        if (result == null) {
            throw OSGiMessages.MESSAGES.startFailedCannotResolveInitialCapability(null, identifier);
        }
        return result;
    }

    private boolean isValidModuleIdentifier(String identifier) {
        try {
            ModuleIdentifier.fromString((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidMavenIdentifier(String identifier) {
        try {
            MavenCoordinates.parse((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private ServiceName installBundleFromURL(URL bundleURL, String location, Integer level, ServiceListener<Bundle> listener) throws Exception {
        StorageStateProvider storageProvider;
        StorageState storageState;
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.toVirtualFile((URL)bundleURL), (String)location);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        if (level != null) {
            dep.setStartLevel(Integer.valueOf(level));
            dep.setAutoStart(true);
        }
        if ((storageState = (storageProvider = (StorageStateProvider)this.injectedStorageProvider.getValue()).getByLocation(dep.getLocation())) != null) {
            dep.addAttachment(StorageState.class, (Object)storageState);
        }
        return bundleManager.installBundle(dep, listener);
    }

    public synchronized AutoInstallIntegration getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        URL manifestURL = module.getClassLoader().getResource("META-INF/MANIFEST.MF");
        if (manifestURL != null) {
            InputStream input = manifestURL.openStream();
            try {
                Manifest manifest = new Manifest(input);
                if (BundleInfo.isValidBundleManifest((Manifest)manifest)) {
                    OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((Manifest)manifest);
                    return oSGiMetaData;
                }
            }
            finally {
                input.close();
            }
        }
        File homeDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getHomeDir();
        File modulesDir = new File(homeDir + File.separator + "modules");
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', File.separatorChar) + File.separator + identifier.getSlot();
        File entryFile = new File(modulesDir + File.separator + identifierPath + File.separator + "jbosgi-xservice.properties");
        if (entryFile.exists()) {
            FileInputStream input = new FileInputStream(entryFile);
            try {
                OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((InputStream)input);
                return oSGiMetaData;
            }
            finally {
                input.close();
            }
        }
        return null;
    }
}

