/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.List;
import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.BundleInfo;

public class BundleDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceRegistry serviceRegistry;
        ServiceController<Deployment> controller;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String contextName = depUnit.getName();
        Deployment deployment = OSGiDeploymentAttachment.getDeployment(depUnit);
        if (deployment != null) {
            return;
        }
        if (deployment == null && (controller = DeploymentHolderService.getDeployment(serviceRegistry = phaseContext.getServiceRegistry(), contextName)) != null) {
            deployment = (Deployment)controller.getValue();
            deployment.setAutoStart(false);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        BundleInfo info = BundleInfoAttachment.getBundleInfo(depUnit);
        if (deployment == null && info != null) {
            deployment = DeploymentFactory.createDeployment((BundleInfo)info);
            deployment.addAttachment(BundleInfo.class, (Object)info);
            deployment.setAutoStart(true);
        }
        if (deployment != null) {
            DotName runWithName = DotName.createSimple((String)"org.junit.runner.RunWith");
            CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List runWithList = compositeIndex.getAnnotations(runWithName);
            if (!runWithList.isEmpty()) {
                deployment.setAutoStart(false);
            }
            OSGiDeploymentAttachment.attachDeployment(depUnit, deployment);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        OSGiDeploymentAttachment.detachDeployment(depUnit);
    }
}

