/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xnio.IoFuture;

public class IoFutureHelper {
    public static <V> Future<V> future(final IoFuture<V> ioFuture) {
        return new Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return ioFuture.cancel().getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isCancelled() {
                return ioFuture.getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isDone() {
                return ioFuture.getStatus() == IoFuture.Status.DONE;
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                IoFuture.Status status = ioFuture.awaitInterruptibly();
                return this.result(status);
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                IoFuture.Status status = ioFuture.awaitInterruptibly(timeout, unit);
                if (status == IoFuture.Status.WAITING) {
                    throw new TimeoutException("Operation timed out");
                }
                return this.result(status);
            }

            private V result(IoFuture.Status status) throws ExecutionException {
                switch (status) {
                    case CANCELLED: {
                        throw new CancellationException();
                    }
                    case FAILED: {
                        throw new ExecutionException(ioFuture.getException());
                    }
                }
                try {
                    return ioFuture.get();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    public static <V> V get(IoFuture<V> ioFuture, long timeout, TimeUnit unit) throws IOException {
        IoFuture.Status status = ioFuture.await(timeout, unit);
        switch (status) {
            case DONE: {
                return (V)ioFuture.get();
            }
            case FAILED: {
                throw new RuntimeException(ioFuture.getException());
            }
        }
        throw new RuntimeException("Operation failed with status " + status);
    }
}

