/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class ServerStartHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "start";
    private final ServerInventory serverInventory;

    public ServerStartHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(new ModelNode(HostControllerMessages.MESSAGES.cannotStartServersInvalidMode(context.getRunningMode())));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final boolean blocking = operation.get("blocking").asBoolean(false);
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final ServerStatus origStatus = ServerStartHandler.this.serverInventory.determineServerStatus(serverName);
                if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                    ServerStatus status = ServerStartHandler.this.serverInventory.startServer(serverName, model, blocking);
                    context.getResult().set(status.toString());
                } else {
                    context.getResult().set(origStatus.toString());
                }
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                            ServerStartHandler.this.serverInventory.stopServer(serverName, -1);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getStartServerOperation(locale);
    }
}

