/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy.proxy;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.Initializor;

public class MapProxy<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 8418037541773074646L;
    private transient Initializor<Map<K, V>> initializor;
    protected Map<K, V> delegate;

    public MapProxy() {
    }

    public MapProxy(Initializor<Map<K, V>> initializor) {
        this.initializor = initializor;
    }

    private void checkInit() {
        if (this.delegate == null) {
            this.delegate = this.initializor.initialize();
        }
    }

    @Override
    public int size() {
        this.checkInit();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkInit();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        this.checkInit();
        return this.delegate.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        this.checkInit();
        return this.delegate.containsValue(o);
    }

    @Override
    public V get(Object o) {
        this.checkInit();
        return this.delegate.get(o);
    }

    @Override
    public V put(K k, V v) {
        this.checkInit();
        return this.delegate.put(k, v);
    }

    @Override
    public V remove(Object o) {
        this.checkInit();
        return this.delegate.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkInit();
        this.delegate.putAll(map);
    }

    @Override
    public void clear() {
        this.checkInit();
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        this.checkInit();
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        this.checkInit();
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkInit();
        return this.delegate.entrySet();
    }

    public String toString() {
        this.checkInit();
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object obj) {
        this.checkInit();
        return ((Object)this.delegate).equals(obj);
    }

    @Override
    public int hashCode() {
        this.checkInit();
        return ((Object)this.delegate).hashCode();
    }
}

