/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxws.client.DispatchBinding;
import org.jboss.ws.util.xml.BufferedStreamResult;

public class DispatchHTTPBinding
extends DispatchBinding {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DispatchHTTPBinding.class);
    private final Logger log = Logger.getLogger(DispatchHTTPBinding.class);
    private JAXBContext jaxbContext;
    private Class type;
    private Service.Mode mode;

    public DispatchHTTPBinding(Service.Mode mode, Class type, JAXBContext jaxbContext) {
        this.mode = mode;
        this.type = type;
        this.jaxbContext = jaxbContext;
    }

    public MessageAbstraction getRequestMessage(Object obj) {
        HTTPMessageImpl reqMsg = null;
        try {
            if (Source.class.isAssignableFrom(this.type)) {
                Source source = (Source)obj;
                reqMsg = new HTTPMessageImpl(source);
                if (this.validateDispatch) {
                    reqMsg.doValidate();
                }
            } else if (this.jaxbContext != null) {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)true);
                BufferedStreamResult result = new BufferedStreamResult();
                marshaller.marshal(obj, (Result)result);
                reqMsg = new HTTPMessageImpl(result);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_REQUEST_MESSAGE", (Object[])new Object[0]), (Throwable)ex);
        }
        if (reqMsg == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_REQUEST_MESSAGE_FOR", (Object[])new Object[]{obj}));
        }
        return reqMsg;
    }

    public Object getReturnObject(MessageAbstraction message) {
        HTTPMessageImpl resMsg = (HTTPMessageImpl)message;
        Object retObj = null;
        try {
            if (Source.class.isAssignableFrom(this.type)) {
                retObj = resMsg.getXmlFragment().getSource();
            } else if (this.jaxbContext != null) {
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                Source source = resMsg.getXmlFragment().getSource();
                retObj = unmarshaller.unmarshal(source);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PROCESS_RESPONSE_MESSAGE", (Object[])new Object[0]), (Throwable)ex);
        }
        return retObj;
    }
}

