/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import java.util.HashMap;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaToXSD;

public class SchemaGenerator {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SchemaGenerator.class);
    private static final Logger log = Logger.getLogger(SchemaGenerator.class);
    private boolean restrictToTargetNamespace = true;

    public JBossXSModel generateXSDSchema(QName xmlType, Class javaType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateXSDSchema: [xmlType=" + xmlType + ",javaType=" + javaType.getName() + "]"));
        }
        try {
            JBossXSModel xsModel;
            this.assertXmlType(xmlType);
            String nsuri = xmlType.getNamespaceURI();
            Class<?> componentType = javaType;
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            JavaToXSD javaToXSD = new JavaToXSD();
            if (!componentType.isPrimitive()) {
                HashMap<String, String> namespaceMap = new HashMap<String, String>();
                namespaceMap.put(componentType.getPackage().getName(), nsuri);
                javaToXSD.setPackageNamespaceMap(namespaceMap);
            }
            if ((xsModel = javaToXSD.generateForSingleType(xmlType, javaType)) == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GENERATE_XSMODEL", (Object[])new Object[0]));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + xsModel.serialize()));
            }
            return xsModel;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new JAXRPCException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GENERATE_XSDSCHEMA", (Object[])new Object[]{xmlType}), (Throwable)e);
        }
    }

    public void setRestrictToTargetNamespace(boolean restrictToTargetNamespace) {
        this.restrictToTargetNamespace = restrictToTargetNamespace;
    }

    private void assertXmlType(QName xmlType) {
        String nsURI = xmlType.getNamespaceURI();
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NAMESPACE_FOR_TYPE", (Object[])new Object[]{xmlType}));
        }
    }
}

