/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.spi.Sortable;
import org.jboss.arquillian.drone.webdriver.impl.BrowserCapabilitiesRegistryImpl;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class BrowserCapabilitiesRegistrar {
    private static final Comparator<Sortable> SORTABLE_COMPARATOR = new Comparator<Sortable>(){

        @Override
        public int compare(Sortable o1, Sortable o2) {
            return new Integer(o1.getPrecedence()).compareTo(new Integer(o2.getPrecedence()));
        }
    };
    @Inject
    @SuiteScoped
    private InstanceProducer<BrowserCapabilitiesRegistry> browserCapabilitiesRegistry;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void register(@Observes BeforeSuite event) {
        this.browserCapabilitiesRegistry.set((Object)new BrowserCapabilitiesRegistryImpl());
        this.registerBrowserCapabilities();
    }

    private void registerBrowserCapabilities() {
        ArrayList list = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(BrowserCapabilities.class));
        Collections.sort(list, SORTABLE_COMPARATOR);
        for (BrowserCapabilities browser : list) {
            String browserReadableName = browser.getReadableName();
            String browserName = browserReadableName != null ? browserReadableName.toLowerCase() : null;
            ((BrowserCapabilitiesRegistry)this.browserCapabilitiesRegistry.get()).registerBrowserCapabilitiesFor(browserName, browser);
        }
    }
}

