/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionPermanentStorage;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.SerializationUtils;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.Validate;

public class ReusedSessionPermanentFileStorage
implements ReusedSessionPermanentStorage {
    private static final Logger log = Logger.getLogger(ReusedSessionPermanentFileStorage.class.getName());
    public static String FILE_STORE_PROPERTY = "drone.webdriver.session.store";
    public static File DEFAULT_FILE = new File(System.getProperty("user.home"), ".drone-webdriver-session-store");
    private final File permanentFile;

    public ReusedSessionPermanentFileStorage() {
        String storeFileProperty = System.getProperty(FILE_STORE_PROPERTY);
        this.permanentFile = storeFileProperty != null ? new File(storeFileProperty) : DEFAULT_FILE;
    }

    @Override
    public ReusedSessionStore loadStore() {
        try {
            byte[] readStore = this.readStore(this.permanentFile);
            if (readStore == null) {
                return null;
            }
            ReusedSessionStore loadedSession = SerializationUtils.deserializeFromBytes(ReusedSessionStore.class, readStore);
            return loadedSession;
        }
        catch (InvalidClassException e) {
            log.log(Level.WARNING, "Unable to get reused session store from file storage, likely it is due to its internal format change. Drone will replace file " + this.permanentFile + " with recent implementation. Cause: ", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, "Unable to get reused session store from file storage. Drone will replace file " + this.permanentFile + " with recent implementation. Cause: ", e);
            return null;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to get reused session store from file storage. Drone will replace file " + this.permanentFile + " with recent implementation. Cause: ", e);
            return null;
        }
    }

    @Override
    public void writeStore(ReusedSessionStore store) {
        try {
            byte[] serialized = SerializationUtils.serializeToBytes(store);
            this.writeStore(this.permanentFile, serialized);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to persist reused session store, session reuse will not work", e);
        }
    }

    private byte[] readStore(File file) throws IOException {
        if (Validate.readable(file)) {
            return FileUtils.readFileToByteArray((File)file);
        }
        log.info("Reused session store is not available at " + file + ", a new one will be created.");
        return null;
    }

    private void writeStore(File file, byte[] data) throws IOException {
        if (Validate.writeable(file)) {
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            return;
        }
        log.severe("Reused session store cannot be persisted to file, session reuse will not work");
    }
}

