/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.OutputStream;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverFactory
extends AbstractWebDriverFactory<EdgeDriver>
implements Configurator<EdgeDriver, WebDriverConfiguration>,
Instantiator<EdgeDriver, WebDriverConfiguration>,
Destructor<EdgeDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Edge().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(EdgeDriver instance) {
        instance.quit();
    }

    public EdgeDriver createInstance(WebDriverConfiguration configuration) {
        EdgeOptions edgeOptions = this.getEdgeOptions(configuration);
        EdgeDriverService service = (EdgeDriverService)((EdgeDriverService.Builder)new EdgeDriverService.Builder().withLogOutput((OutputStream)System.out)).build();
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{EdgeDriverService.class, EdgeOptions.class}, new Object[]{service, edgeOptions}, EdgeDriver.class);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }

    public EdgeOptions getEdgeOptions(WebDriverConfiguration configuration) {
        Capabilities capabilities = configuration.getCapabilities();
        EdgeOptions edgeOptions = new EdgeOptions();
        CapabilitiesOptionsMapper.mapCapabilities(edgeOptions, capabilities, BROWSER_CAPABILITIES);
        return edgeOptions;
    }
}

