/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.container;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.event.ContainerControlEvent;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.KillContainer;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContainerController
implements ContainerController {
    private final Logger log = Logger.getLogger(ClientContainerController.class.getName());
    @Inject
    private Event<ContainerControlEvent> event;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;

    public void start(String containerQualifier) {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isManualContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        List managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        this.log.info("Manual starting of a server instance");
        this.event.fire((Object)new StartContainer(container));
        for (Deployment d : managedDeployments) {
            if (d.isDeployed()) continue;
            this.log.info("Automatic deploying of the managed deployment with name " + d.getDescription().getName() + " for the container with name " + container.getName());
            this.event.fire((Object)new DeployDeployment(container, d));
        }
    }

    public void start(String containerQualifier, Map<String, String> config) {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isManualContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        List managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        for (String name : config.keySet()) {
            container.getContainerConfiguration().overrideProperty(name, config.get(name));
        }
        this.log.info("Manual starting of a server instance with overridden configuration. New configuration: " + container.getContainerConfiguration().getContainerProperties());
        this.event.fire((Object)new SetupContainer(container));
        this.event.fire((Object)new StartContainer(container));
        for (Deployment d : managedDeployments) {
            if (d.isDeployed()) continue;
            this.log.info("Automatic deploying of the managed deployment with name " + d.getDescription().getName() + " for the container with name " + container.getName());
            this.event.fire((Object)new DeployDeployment(container, d));
        }
    }

    public void stop(String containerQualifier) {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isManualContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        List managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        for (Deployment d : managedDeployments) {
            if (!d.isDeployed()) continue;
            this.log.info("Automatic undeploying of the managed deployment with name " + d.getDescription().getName() + " from the container with name " + container.getName());
            this.event.fire((Object)new UnDeployDeployment(container, d));
        }
        this.log.info("Manual stopping of a server instance");
        this.event.fire((Object)new StopContainer(container));
    }

    public void kill(String containerQualifier) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isManualContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        this.log.info("Hard killing of a server instance");
        this.event.fire((Object)new KillContainer(container));
    }

    private boolean containerExists(List<Container> containers, String name) {
        for (Container container : containers) {
            if (!container.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isManualContainer(List<Container> containers, String containerQualifier) {
        for (Container container : containers) {
            if (!container.getName().equals(containerQualifier) || !"manual".equals(container.getContainerConfiguration().getMode())) continue;
            return true;
        }
        return false;
    }
}

