/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.enricher.resource;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.impl.enricher.resource.ResourceProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;

    @Override
    public Object lookup(ArquillianResource resource) {
        ProtocolMetaData metaData = (ProtocolMetaData)this.protocolMetadata.get();
        if (metaData == null) {
            return null;
        }
        if (metaData.hasContext(HTTPContext.class)) {
            HTTPContext context = (HTTPContext)metaData.getContext(HTTPContext.class);
            if (resource.value() != null && resource.value() != ArquillianResource.class) {
                Servlet servlet = context.getServletByName(resource.value().getSimpleName());
                if (servlet == null) {
                    servlet = context.getServletByName(resource.value().getName());
                }
                if (servlet == null) {
                    return null;
                }
                return this.toURL(servlet);
            }
            if (this.allInSameContext(context.getServlets())) {
                return this.toURL((Servlet)context.getServlets().get(0));
            }
            return this.toURL(context);
        }
        return null;
    }

    private boolean allInSameContext(List<Servlet> servlets) {
        HashSet<String> context = new HashSet<String>();
        for (Servlet servlet : servlets) {
            context.add(servlet.getContextRoot());
        }
        return context.size() == 1;
    }

    private URL toURL(Servlet servlet) {
        try {
            return servlet.getBaseURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert Servlet to URL, " + servlet, e);
        }
    }

    private URL toURL(HTTPContext context) {
        try {
            return new URI("http", null, context.getHost(), context.getPort(), null, null, null).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert Servlet to URL, " + context, e);
        }
    }
}

