/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool.ucl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AbstractJBossDelegatingClassPoolFactory;
import org.jboss.aop.classpool.BaseClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolDomainRegistry;
import org.jboss.aop.classpool.NonDelegatingClassPool;
import org.jboss.aop.classpool.ucl.JBossUclDelegatingClassPool;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossUclDelegatingClassPoolFactory
extends AbstractJBossDelegatingClassPoolFactory
implements ScopedClassPoolFactory {
    private ClassPoolDomain mainDomain;
    protected File tmpClassesDir;

    public JBossUclDelegatingClassPoolFactory(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public synchronized ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        if (cl instanceof RepositoryClassLoader) {
            ClassPoolDomain domain = this.getDomain((RepositoryClassLoader)cl);
            File tempdir = this.getTempDirectory(cl);
            URL tmpCP = this.createURLAndAddToLoader(cl, tempdir);
            return new JBossUclDelegatingClassPool(domain, cl, parent, repository, tempdir, tmpCP);
        }
        return new NonDelegatingClassPool(cl, parent, repository, true);
    }

    private ClassPoolDomain getDomain(RepositoryClassLoader cl) {
        LoaderRepository loaderRepository = cl.getLoaderRepository();
        ClassPoolDomainRegistry registry = ClassPoolDomainRegistry.getInstance();
        ClassPoolDomain domain = registry.getDomain((Object)loaderRepository);
        if (domain == null) {
            if (loaderRepository instanceof HeirarchicalLoaderRepository3) {
                boolean parentFirst = ((HeirarchicalLoaderRepository3)loaderRepository).getUseParentFirst();
                domain = new BaseClassPoolDomain("Scoped" + System.identityHashCode(loaderRepository), this.mainDomain, parentFirst);
            } else {
                if (this.mainDomain == null) {
                    this.mainDomain = domain = new BaseClassPoolDomain("JMImplementation:service=LoaderRepository,name=Default", null, false);
                } else {
                    domain = this.mainDomain;
                }
                registry.addClassPoolDomain((Object)loaderRepository, domain);
            }
        }
        return domain;
    }

    protected File getTempDirectory(ClassLoader cl) {
        File tempdir = null;
        int attempts = 0;
        IOException ex = null;
        while (tempdir == null && attempts < 5) {
            try {
                tempdir = this.createTempDir(cl);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (tempdir == null) {
            throw new RuntimeException("", ex);
        }
        return tempdir;
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        return tempdir;
    }

    private URL createURLAndAddToLoader(ClassLoader cl, File tempdir) {
        try {
            URL tmpURL = tempdir.toURL();
            URL tmpCP = new URL(tmpURL, "?dynamic=true");
            RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
            if (ucl.getLoaderRepository() != null) {
                ucl.addURL(tmpCP);
            }
            return tmpCP;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

