/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternVariantBuilder {
    private final Pattern regex = Pattern.compile("([^\\n{]*+)(\\{(([^|}]++)(\\|)?+)*+\\})([^\\n]*+)");
    private final Set<String> variants;
    private final String input;

    public PatternVariantBuilder(String input) {
        this.input = input;
        this.variants = this.variantsFor(input);
    }

    public String getInput() {
        return this.input;
    }

    private Set<String> variantsFor(String input) {
        HashSet<String> variants = new HashSet<String>();
        Matcher m = this.regex.matcher(input);
        boolean matches = m.matches();
        if (!matches) {
            variants.add(input);
            return variants;
        }
        String head = m.group(1);
        String patternGroup = m.group(2).replaceAll("[\\{\\}]", "");
        String tail = m.group(6);
        ArrayList<String> patternParts = new ArrayList<String>();
        patternParts.addAll(Arrays.asList(patternGroup.split("\\|")));
        if (patternGroup.endsWith("|")) {
            patternParts.add("");
        }
        for (String part : patternParts) {
            StringBuilder builder = new StringBuilder();
            if (head != null) {
                builder.append(head);
            }
            builder.append(part);
            Set<String> tails = this.variantsFor(tail);
            for (String tailVariant : tails) {
                StringBuilder tailBuilder = new StringBuilder(builder.toString());
                tailBuilder.append(tailVariant);
                variants.add(tailBuilder.toString());
            }
        }
        return variants;
    }

    public Set<String> allVariants() {
        return this.allVariants(false);
    }

    public Set<String> allVariants(boolean compressWhitespace) {
        if (!compressWhitespace) {
            return new HashSet<String>(this.variants);
        }
        HashSet<String> compressed = new HashSet<String>();
        for (String variant : this.variants) {
            compressed.add(variant.replaceAll("\\s{2,}", " "));
        }
        return compressed;
    }
}

