/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.model.StepPattern;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.steps.StepType;

public class RegexStepMatcher
implements StepMatcher {
    private final Pattern regexPattern;
    private final String[] parameterNames;
    private final StepPattern stepPattern;
    private Matcher matcher;

    public RegexStepMatcher(StepType stepType, String annotatedPattern, Pattern regexPattern, String[] parameterNames) {
        this.regexPattern = regexPattern;
        this.parameterNames = parameterNames;
        this.stepPattern = new StepPattern(stepType, annotatedPattern, regexPattern.pattern());
    }

    public boolean matches(String stepWithoutStartingWord) {
        this.matcher(stepWithoutStartingWord);
        return this.matcher.matches();
    }

    public boolean find(String stepWithoutStartingWord) {
        this.matcher(stepWithoutStartingWord);
        return this.matcher.find();
    }

    public String parameter(int matchedPosition) {
        return this.matcher.group(matchedPosition);
    }

    private void matcher(String patternToMatch) {
        this.matcher = this.regexPattern.matcher(patternToMatch);
    }

    public String[] parameterNames() {
        return this.parameterNames;
    }

    public StepPattern pattern() {
        return this.stepPattern;
    }
}

