/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GivenStory {
    private static final String PATH_REGEX = "(.*)\\#\\{(.*?)\\}";
    private static final String PARAMETERS_REGEX = ".*(\\:|\\;).*";
    private final String givenStoryAsString;
    private Map<String, String> parameters = new HashMap<String, String>();
    private String path;
    private String anchor;

    public GivenStory(String givenStoryAsString) {
        this.givenStoryAsString = givenStoryAsString.trim();
        this.parse();
    }

    private void parse() {
        Pattern pattern = Pattern.compile(PATH_REGEX, 32);
        Matcher matcher = pattern.matcher(this.givenStoryAsString.trim());
        if (matcher.matches()) {
            this.path = matcher.group(1).trim();
            this.anchor = matcher.group(2).trim();
        } else {
            this.path = this.givenStoryAsString;
            this.anchor = "";
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public boolean hasAnchor() {
        return !StringUtils.isBlank((String)this.anchor);
    }

    public boolean hasAnchorParameters() {
        return this.hasAnchor() && this.anchor.matches(PARAMETERS_REGEX);
    }

    public Map<String, String> getAnchorParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : this.anchor.trim().split(";")) {
            String[] split = pair.split(":");
            if (split.length <= 1) continue;
            parameters.put(split[0], split[1]);
        }
        return parameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void useParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String asString() {
        return this.givenStoryAsString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

