/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keywords {
    private static final String SYNONYM_SEPARATOR = "\\|";
    public static final String META = "Meta";
    public static final String META_PROPERTY = "MetaProperty";
    public static final String NARRATIVE = "Narrative";
    public static final String IN_ORDER_TO = "InOrderTo";
    public static final String AS_A = "AsA";
    public static final String I_WANT_TO = "IWantTo";
    public static final String SCENARIO = "Scenario";
    public static final String GIVEN_STORIES = "GivenStories";
    public static final String EXAMPLES_TABLE = "ExamplesTable";
    public static final String EXAMPLES_TABLE_ROW = "ExamplesTableRow";
    public static final String EXAMPLES_TABLE_HEADER_SEPARATOR = "ExamplesTableHeaderSeparator";
    public static final String EXAMPLES_TABLE_VALUE_SEPARATOR = "ExamplesTableValueSeparator";
    public static final String EXAMPLES_TABLE_IGNORABLE_SEPARATOR = "ExamplesTableIgnorableSeparator";
    public static final String GIVEN = "Given";
    public static final String WHEN = "When";
    public static final String THEN = "Then";
    public static final String AND = "And";
    public static final String IGNORABLE = "Ignorable";
    public static final String PENDING = "Pending";
    public static final String NOT_PERFORMED = "NotPerformed";
    public static final String FAILED = "Failed";
    public static final String DRY_RUN = "DryRun";
    public static final String STORY_CANCELLED = "StoryCancelled";
    public static final String DURATION = "Duration";
    public static final String OUTCOME_DESCRIPTION = "OutcomeDescription";
    public static final String OUTCOME_VALUE = "OutcomeValue";
    public static final String OUTCOME_MATCHER = "OutcomeMatcher";
    public static final String OUTCOME_VERIFIED = "OutcomeVerified";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final List<String> KEYWORDS = Arrays.asList("Meta", "MetaProperty", "Narrative", "InOrderTo", "AsA", "IWantTo", "Scenario", "GivenStories", "ExamplesTable", "ExamplesTableRow", "ExamplesTableHeaderSeparator", "ExamplesTableValueSeparator", "ExamplesTableIgnorableSeparator", "Given", "When", "Then", "And", "Ignorable", "Pending", "NotPerformed", "Failed", "DryRun", "StoryCancelled", "Duration", "OutcomeDescription", "OutcomeValue", "OutcomeMatcher", "OutcomeVerified", "Yes", "No");
    private final String meta;
    private final String metaProperty;
    private final String narrative;
    private final String inOrderTo;
    private final String asA;
    private final String iWantTo;
    private final String scenario;
    private final String givenStories;
    private final String examplesTable;
    private final String examplesTableRow;
    private final String examplesTableHeaderSeparator;
    private final String examplesTableValueSeparator;
    private final String examplesTableIgnorableSeparator;
    private final String given;
    private final String when;
    private final String then;
    private final String and;
    private final String ignorable;
    private final String pending;
    private final String notPerformed;
    private final String failed;
    private final String dryRun;
    private final String storyCancelled;
    private final String duration;
    private final String outcomeDescription;
    private final String outcomeValue;
    private final String outcomeMatcher;
    private final String outcomeVerified;
    private final String yes;
    private final String no;
    private final Map<StepType, String> startingWordsByType = new HashMap<StepType, String>();

    public static Map<String, String> defaultKeywords() {
        HashMap<String, String> keywords = new HashMap<String, String>();
        keywords.put(META, "Meta:");
        keywords.put(META_PROPERTY, "@");
        keywords.put(NARRATIVE, "Narrative:");
        keywords.put(IN_ORDER_TO, "In order to:");
        keywords.put(AS_A, "As a:");
        keywords.put(I_WANT_TO, "I want to:");
        keywords.put(SCENARIO, "Scenario:");
        keywords.put(GIVEN_STORIES, "GivenStories:");
        keywords.put(EXAMPLES_TABLE, "Examples:");
        keywords.put(EXAMPLES_TABLE_ROW, "Example:");
        keywords.put(EXAMPLES_TABLE_HEADER_SEPARATOR, "|");
        keywords.put(EXAMPLES_TABLE_VALUE_SEPARATOR, "|");
        keywords.put(EXAMPLES_TABLE_IGNORABLE_SEPARATOR, "|--");
        keywords.put(GIVEN, GIVEN);
        keywords.put(WHEN, WHEN);
        keywords.put(THEN, THEN);
        keywords.put(AND, AND);
        keywords.put(IGNORABLE, "!--");
        keywords.put(PENDING, "PENDING");
        keywords.put(NOT_PERFORMED, "NOT PERFORMED");
        keywords.put(FAILED, "FAILED");
        keywords.put(DRY_RUN, "DRY RUN");
        keywords.put(STORY_CANCELLED, "STORY CANCELLED");
        keywords.put(DURATION, "DURATION");
        keywords.put(OUTCOME_DESCRIPTION, "DESCRIPTION");
        keywords.put(OUTCOME_MATCHER, "MATCHER");
        keywords.put(OUTCOME_VALUE, "VALUE");
        keywords.put(OUTCOME_VERIFIED, "VERIFIED");
        keywords.put(YES, YES);
        keywords.put(NO, NO);
        return keywords;
    }

    public Keywords() {
        this(Keywords.defaultKeywords());
    }

    public Keywords(Map<String, String> keywords) {
        this.meta = this.keyword(META, keywords);
        this.metaProperty = this.keyword(META_PROPERTY, keywords);
        this.narrative = this.keyword(NARRATIVE, keywords);
        this.inOrderTo = this.keyword(IN_ORDER_TO, keywords);
        this.asA = this.keyword(AS_A, keywords);
        this.iWantTo = this.keyword(I_WANT_TO, keywords);
        this.scenario = this.keyword(SCENARIO, keywords);
        this.givenStories = this.keyword(GIVEN_STORIES, keywords);
        this.examplesTable = this.keyword(EXAMPLES_TABLE, keywords);
        this.examplesTableRow = this.keyword(EXAMPLES_TABLE_ROW, keywords);
        this.examplesTableHeaderSeparator = this.keyword(EXAMPLES_TABLE_HEADER_SEPARATOR, keywords);
        this.examplesTableValueSeparator = this.keyword(EXAMPLES_TABLE_VALUE_SEPARATOR, keywords);
        this.examplesTableIgnorableSeparator = this.keyword(EXAMPLES_TABLE_IGNORABLE_SEPARATOR, keywords);
        this.given = this.keyword(GIVEN, keywords);
        this.when = this.keyword(WHEN, keywords);
        this.then = this.keyword(THEN, keywords);
        this.and = this.keyword(AND, keywords);
        this.ignorable = this.keyword(IGNORABLE, keywords);
        this.pending = this.keyword(PENDING, keywords);
        this.notPerformed = this.keyword(NOT_PERFORMED, keywords);
        this.failed = this.keyword(FAILED, keywords);
        this.dryRun = this.keyword(DRY_RUN, keywords);
        this.storyCancelled = this.keyword(STORY_CANCELLED, keywords);
        this.duration = this.keyword(DURATION, keywords);
        this.outcomeDescription = this.keyword(OUTCOME_DESCRIPTION, keywords);
        this.outcomeMatcher = this.keyword(OUTCOME_MATCHER, keywords);
        this.outcomeValue = this.keyword(OUTCOME_VALUE, keywords);
        this.outcomeVerified = this.keyword(OUTCOME_VERIFIED, keywords);
        this.yes = this.keyword(YES, keywords);
        this.no = this.keyword(NO, keywords);
        this.startingWordsByType.put(StepType.GIVEN, this.given());
        this.startingWordsByType.put(StepType.WHEN, this.when());
        this.startingWordsByType.put(StepType.THEN, this.then());
        this.startingWordsByType.put(StepType.AND, this.and());
        this.startingWordsByType.put(StepType.IGNORABLE, this.ignorable());
    }

    private String keyword(String name, Map<String, String> keywords) {
        String keyword = keywords.get(name);
        if (keyword == null) {
            throw new KeywordNotFound(name, keywords);
        }
        return keyword;
    }

    public String meta() {
        return this.meta;
    }

    public String metaProperty() {
        return this.metaProperty;
    }

    public String narrative() {
        return this.narrative;
    }

    public String inOrderTo() {
        return this.inOrderTo;
    }

    public String asA() {
        return this.asA;
    }

    public String iWantTo() {
        return this.iWantTo;
    }

    public String scenario() {
        return this.scenario;
    }

    public String givenStories() {
        return this.givenStories;
    }

    public String examplesTable() {
        return this.examplesTable;
    }

    public String examplesTableRow() {
        return this.examplesTableRow;
    }

    public String examplesTableHeaderSeparator() {
        return this.examplesTableHeaderSeparator;
    }

    public String examplesTableValueSeparator() {
        return this.examplesTableValueSeparator;
    }

    public String examplesTableIgnorableSeparator() {
        return this.examplesTableIgnorableSeparator;
    }

    public String given() {
        return this.given;
    }

    public String when() {
        return this.when;
    }

    public String then() {
        return this.then;
    }

    public String and() {
        return this.and;
    }

    public String ignorable() {
        return this.ignorable;
    }

    public String pending() {
        return this.pending;
    }

    public String notPerformed() {
        return this.notPerformed;
    }

    public String failed() {
        return this.failed;
    }

    public String dryRun() {
        return this.dryRun;
    }

    public String storyCancelled() {
        return this.storyCancelled;
    }

    public String duration() {
        return this.duration;
    }

    public List<String> outcomeFields() {
        return Arrays.asList(this.outcomeDescription, this.outcomeValue, this.outcomeMatcher, this.outcomeVerified);
    }

    public String yes() {
        return this.yes;
    }

    public String no() {
        return this.no;
    }

    public String[] synonymsOf(String word) {
        return word.split(SYNONYM_SEPARATOR);
    }

    public String[] startingWords() {
        ArrayList<String> words = new ArrayList<String>();
        for (String word : this.startingWordsByType().values()) {
            words.addAll(Arrays.asList(this.synonymsOf(word)));
        }
        return words.toArray(new String[words.size()]);
    }

    public Map<StepType, String> startingWordsByType() {
        return this.startingWordsByType;
    }

    private boolean ofStepType(String stepAsString, StepType stepType) {
        String word;
        boolean isType = false;
        String[] arr$ = this.startingWordsFor(stepType);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(isType = this.stepStartsWithWord(stepAsString, word = arr$[i$])); ++i$) {
        }
        return isType;
    }

    public boolean isAndStep(String stepAsString) {
        return this.ofStepType(stepAsString, StepType.AND);
    }

    public boolean isIgnorableStep(String stepAsString) {
        return this.ofStepType(stepAsString, StepType.IGNORABLE);
    }

    public String stepWithoutStartingWord(String stepAsString, StepType stepType) {
        String startingWord = this.startingWord(stepAsString, stepType);
        return stepAsString.substring(startingWord.length() + 1);
    }

    public String startingWord(String stepAsString, StepType stepType) throws StartingWordNotFound {
        for (String wordForType : this.startingWordsFor(stepType)) {
            if (!this.stepStartsWithWord(stepAsString, wordForType)) continue;
            return wordForType;
        }
        for (String andWord : this.startingWordsFor(StepType.AND)) {
            if (!this.stepStartsWithWord(stepAsString, andWord)) continue;
            return andWord;
        }
        throw new StartingWordNotFound(stepAsString, stepType, this.startingWordsByType);
    }

    public String startingWord(String stepAsString) throws StartingWordNotFound {
        for (StepType stepType : this.startingWordsByType.keySet()) {
            for (String wordForType : this.startingWordsFor(stepType)) {
                if (!this.stepStartsWithWord(stepAsString, wordForType)) continue;
                return wordForType;
            }
        }
        throw new StartingWordNotFound(stepAsString, this.startingWordsByType);
    }

    public StepType stepTypeFor(String stepAsString) throws StartingWordNotFound {
        for (StepType stepType : this.startingWordsByType.keySet()) {
            for (String wordForType : this.startingWordsFor(stepType)) {
                if (!this.stepStartsWithWord(stepAsString, wordForType)) continue;
                return stepType;
            }
        }
        throw new StartingWordNotFound(stepAsString, this.startingWordsByType);
    }

    public boolean stepStartsWithWord(String step, String word) {
        return step.startsWith(word + " ");
    }

    public String startingWordFor(StepType stepType) {
        String startingWord = this.startingWordsByType.get((Object)stepType);
        if (startingWord == null) {
            throw new StartingWordNotFound(stepType, this.startingWordsByType);
        }
        return startingWord;
    }

    public String[] startingWordsFor(StepType stepType) {
        return this.synonymsOf(this.startingWordFor(stepType));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartingWordNotFound
    extends RuntimeException {
        public StartingWordNotFound(String step, StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found for step '" + step + "' of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }

        public StartingWordNotFound(String step, Map<StepType, String> startingWordsByType) {
            super("No starting word found for step '" + step + "' amongst '" + startingWordsByType + "'");
        }

        public StartingWordNotFound(StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeywordNotFound
    extends RuntimeException {
        public KeywordNotFound(String name, Map<String, String> keywords) {
            super("Keyword " + name + " not found amongst " + keywords);
        }
    }
}

