/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.TypeMapperLazy;

public class MultisetType
extends CollectionType {
    public MultisetType(Type baseJavaType, TypeMapperLazy typeMapperLazy) {
        super(baseJavaType, typeMapperLazy);
    }

    @Override
    public Object map(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        Multiset sourceMultiset = this.toNotNullMultiset(sourceEnumerable);
        HashMultiset targetMultiset = HashMultiset.create();
        EnumerationAwareOwnerContext enumeratorContext = new EnumerationAwareOwnerContext(owner, true);
        for (Object sourceVal : sourceMultiset) {
            targetMultiset.add(mapFunction.apply(sourceVal, enumeratorContext));
        }
        return Multisets.unmodifiableMultiset((Multiset)targetMultiset);
    }

    @Override
    public Object map(Object sourceEnumerable, Function mapFunction, boolean filterNulls) {
        Validate.argumentIsNotNull(mapFunction);
        Multiset sourceMultiset = this.toNotNullMultiset(sourceEnumerable);
        HashMultiset targetMultiset = HashMultiset.create();
        for (Object sourceVal : sourceMultiset) {
            Object mappedVale = mapFunction.apply(sourceVal);
            if (mappedVale == null && filterNulls) continue;
            targetMultiset.add(mappedVale);
        }
        return targetMultiset;
    }

    private Multiset toNotNullMultiset(Object sourceSet) {
        if (sourceSet == null) {
            return HashMultiset.create();
        }
        return (Multiset)sourceSet;
    }

    @Override
    public Object empty() {
        return HashMultiset.create();
    }

    @Override
    public Class<?> getEnumerableInterface() {
        return Multiset.class;
    }
}

