/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.TypeMapperLazy;

public abstract class EnumerableType
extends ClassType {
    private final TypeMapperLazy typeMapperLazy;

    EnumerableType(Type baseJavaType, int expectedArgs, TypeMapperLazy typeMapperLazy) {
        super(baseJavaType, Optional.empty(), expectedArgs);
        this.typeMapperLazy = typeMapperLazy;
    }

    @Override
    protected Object[] spawnConstructorArgs(Type baseJavaType) {
        return new Object[]{baseJavaType, this.getTypeMapperLazy()};
    }

    @Override
    protected Class[] spawnConstructorArgTypes() {
        return new Class[]{Type.class, TypeMapperLazy.class};
    }

    protected TypeMapperLazy getTypeMapperLazy() {
        return this.typeMapperLazy;
    }

    public abstract Object map(Object var1, EnumerableFunction var2, OwnerContext var3);

    public abstract Class<?> getEnumerableInterface();

    public Object map(Object sourceEnumerable, Function mapFunction) {
        return this.map(sourceEnumerable, mapFunction, false);
    }

    public Object mapPreservingSourceItemType(Object sourceEnumerable, Function mapFunction) {
        return this.map(sourceEnumerable, mapFunction);
    }

    public abstract Object map(Object var1, Function var2, boolean var3);

    public abstract boolean isEmpty(Object var1);

    public abstract Object empty();

    public <T> List<T> filterToList(Object source, Class<T> filter) {
        Validate.argumentsAreNotNull(filter);
        return Collections.unmodifiableList(this.items(source).filter(item -> item != null && filter.isAssignableFrom(item.getClass())).collect(Collectors.toList()));
    }

    protected abstract Stream<Object> items(Object var1);
}

