/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.Optional;
import java.util.function.Supplier;
import org.javers.common.validation.Validate;
import org.javers.core.graph.ObjectAccessor;

public class ObjectAccessProxy<T>
implements ObjectAccessor<T> {
    private final Class<T> javaClass;
    private final Object localId;
    private final Supplier<T> objectSupplier;

    public ObjectAccessProxy(Supplier<T> objectSupplier, Class<T> javaClass, Object localId) {
        Validate.argumentsAreNotNull(objectSupplier, javaClass);
        this.javaClass = javaClass;
        this.objectSupplier = objectSupplier;
        this.localId = localId;
    }

    @Override
    public Class getTargetClass() {
        return this.javaClass;
    }

    @Override
    public Optional<Object> getLocalId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public T access() {
        return this.objectSupplier.get();
    }

    public Supplier<T> getObjectSupplier() {
        return this.objectSupplier;
    }
}

