/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.aggr;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.resourceserver.aggr.AggregationException;
import org.jasig.resourceserver.aggr.ResourcesDao;
import org.jasig.resourceserver.aggr.om.BasicInclude;
import org.jasig.resourceserver.aggr.om.Css;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.aggr.om.Js;
import org.jasig.resourceserver.aggr.om.ObjectFactory;
import org.jasig.resourceserver.aggr.om.Resources;

public class ResourcesDaoImpl
implements ResourcesDao {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final ThreadLocal<Set<File>> VISITED = new ThreadLocal<Set<File>>(){

        @Override
        protected Set<File> initialValue() {
            return new LinkedHashSet<File>();
        }
    };
    private final CssResourceLoadCallback CSS_INSTANCE = new CssResourceLoadCallback();
    private final JsResourceLoadCallback JS_INSTANCE = new JsResourceLoadCallback();
    protected final Log logger;
    private Map<File, Resources> loadedResources = new ConcurrentHashMap<File, Resources>();
    private String schemaLocation;
    private final JAXBContext jaxbContext;
    private final String encoding;

    public ResourcesDaoImpl() {
        this(null, DEFAULT_ENCODING);
    }

    public ResourcesDaoImpl(String encoding) {
        this(null, encoding);
    }

    public ResourcesDaoImpl(Log logger, String encoding) {
        this.logger = logger != null ? logger : LogFactory.getLog(this.getClass());
        this.encoding = encoding;
        try {
            this.jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to configure JAXBContext", e);
        }
    }

    public void setLoadedResources(Map<File, Resources> loadedResources) {
        this.loadedResources = loadedResources;
    }

    @Override
    public void writeResources(Resources resources, File file) {
        try {
            Marshaller m = this.jaxbContext.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)this.encoding);
            m.setProperty("jaxb.formatted.output", (Object)true);
            if (this.schemaLocation != null) {
                m.setProperty("jaxb.schemaLocation", (Object)this.schemaLocation);
            }
            m.marshal((Object)resources, file);
        }
        catch (JAXBException e) {
            throw new AggregationException("Failed to marshal Resources to: " + file, e);
        }
    }

    @Override
    public Resources readResources(File resourcesXml, Included scope) {
        File filteredCacheKey = new File(resourcesXml, "__" + (Object)((Object)scope));
        Resources filteredResources = this.loadedResources.get(filteredCacheKey);
        if (filteredResources != null) {
            return filteredResources;
        }
        Resources resources = this.readResources(resourcesXml);
        filteredResources = new Resources();
        filteredResources.getParameter().addAll(resources.getParameter());
        List<Css> filteredCss = filteredResources.getCss();
        for (Css css : resources.getCss()) {
            Included included = css.getIncluded();
            if (included != Included.BOTH && scope != Included.BOTH && included != scope) continue;
            filteredCss.add(css);
        }
        List<Js> filteredJs = filteredResources.getJs();
        for (Js js : resources.getJs()) {
            Included included = js.getIncluded();
            if (included != Included.BOTH && scope != Included.BOTH && included != scope) continue;
            filteredJs.add(js);
        }
        this.loadedResources.put(filteredCacheKey, filteredResources);
        return filteredResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resources readResources(File resourcesXml) {
        Resources resources = this.loadedResources.get(resourcesXml);
        if (resources != null) {
            return resources;
        }
        Set<File> visited = VISITED.get();
        try {
            if (!visited.add(resourcesXml)) {
                throw new IllegalArgumentException("There is a loop in the resource file imports: " + visited);
            }
            this.logger.debug((Object)("Loading Resources from: " + resourcesXml));
            try {
                Unmarshaller u = this.jaxbContext.createUnmarshaller();
                resources = (Resources)u.unmarshal(resourcesXml);
            }
            catch (JAXBException e) {
                throw new AggregationException("Failed to unmarshal Resources file: " + resourcesXml, e);
            }
            File resourcesParentDir = resourcesXml.getParentFile();
            List<Css> cssList = resources.getCss();
            this.loadIncludes(resourcesParentDir, cssList, this.CSS_INSTANCE);
            List<Js> JsList = resources.getJs();
            this.loadIncludes(resourcesParentDir, JsList, this.JS_INSTANCE);
            this.loadedResources.put(resourcesXml, resources);
            Resources resources2 = resources;
            return resources2;
        }
        finally {
            visited.remove(resourcesXml);
            if (visited.size() == 0) {
                VISITED.remove();
            }
        }
    }

    @Override
    public String getAggregatedSkinName(String skinXmlName) {
        String resourcesXmlBaseName = FilenameUtils.getBaseName((String)skinXmlName);
        String resourcesXmlExtension = FilenameUtils.getExtension((String)skinXmlName);
        return resourcesXmlBaseName + ".aggr." + resourcesXmlExtension;
    }

    @Override
    public boolean isAbsolute(BasicInclude include) {
        String value = include.getValue();
        if (null == value) {
            return false;
        }
        return value.startsWith("/") || value.startsWith("http://") || value.startsWith("https://");
    }

    @Override
    public boolean isConditional(BasicInclude include) {
        return StringUtils.isNotBlank((String)include.getConditional());
    }

    protected <T extends BasicInclude> void loadIncludes(File resourcesParentDir, List<T> resources, ResourceLoadCallback<T> callback) {
        ListIterator<T> resourceItr = resources.listIterator();
        while (resourceItr.hasNext()) {
            BasicInclude resource = (BasicInclude)resourceItr.next();
            if (!resource.isImport()) continue;
            resourceItr.remove();
            String importFile = resource.getValue();
            File importedResourcesFile = new File(resourcesParentDir, importFile);
            Resources importedResources = this.readResources(importedResourcesFile);
            List<T> resourceImports = callback.getImportedIncludes(importedResources);
            for (BasicInclude resourceImport : resourceImports) {
                BasicInclude modifiedImport = callback.importResource(importFile, resourceImport);
                resourceItr.add(modifiedImport);
            }
        }
    }

    public class JsResourceLoadCallback
    implements ResourceLoadCallback<Js> {
        @Override
        public Js importResource(String importBase, Js source) {
            Js modifiedJsImport = new Js();
            modifiedJsImport.setCompressed(source.isCompressed());
            modifiedJsImport.setConditional(source.getConditional());
            modifiedJsImport.setImport(source.isImport());
            modifiedJsImport.setIncluded(source.getIncluded());
            modifiedJsImport.setResource(source.isResource());
            if (ResourcesDaoImpl.this.isAbsolute(source)) {
                modifiedJsImport.setValue(source.getValue());
            } else {
                String importPath = FilenameUtils.getPath((String)importBase);
                modifiedJsImport.setValue(importPath + source.getValue());
            }
            return modifiedJsImport;
        }

        @Override
        public List<Js> getImportedIncludes(Resources importedResources) {
            return importedResources.getJs();
        }
    }

    public class CssResourceLoadCallback
    implements ResourceLoadCallback<Css> {
        @Override
        public Css importResource(String importBase, Css source) {
            Css modifiedCssImport = new Css();
            modifiedCssImport.setCompressed(source.isCompressed());
            modifiedCssImport.setConditional(source.getConditional());
            modifiedCssImport.setImport(source.isImport());
            modifiedCssImport.setIncluded(source.getIncluded());
            modifiedCssImport.setMedia(source.getMedia());
            modifiedCssImport.setResource(source.isResource());
            if (ResourcesDaoImpl.this.isAbsolute(source)) {
                modifiedCssImport.setValue(source.getValue());
            } else {
                String importPath = FilenameUtils.getPath((String)importBase);
                modifiedCssImport.setValue(importPath + source.getValue());
            }
            return modifiedCssImport;
        }

        @Override
        public List<Css> getImportedIncludes(Resources importedResources) {
            return importedResources.getCss();
        }
    }

    public static interface ResourceLoadCallback<T extends BasicInclude> {
        public T importResource(String var1, T var2);

        public List<T> getImportedIncludes(Resources var1);
    }
}

