/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.page;

import java.io.IOException;
import java.io.Reader;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.page.NodePage;
import org.jacoco.report.internal.html.page.ReportPage;
import org.jacoco.report.internal.html.page.SourceHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFilePage
extends NodePage<ISourceFileCoverage> {
    private final Reader sourceReader;
    private final int tabWidth;

    public SourceFilePage(ISourceFileCoverage sourceFileNode, Reader sourceReader, int tabWidth, ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context) {
        super(sourceFileNode, parent, folder, context);
        this.sourceReader = sourceReader;
        this.tabWidth = tabWidth;
    }

    @Override
    protected void content(HTMLElement body) throws IOException {
        SourceHighlighter hl = new SourceHighlighter(this.context.getLocale());
        hl.render(body, (ISourceNode)this.getNode(), this.sourceReader);
        this.sourceReader.close();
    }

    @Override
    protected void headExtra(HTMLElement head) throws IOException {
        super.headExtra(head);
        head.link("stylesheet", this.context.getResources().getLink(this.folder, "prettify.css"), "text/css");
        head.script("text/javascript", this.context.getResources().getLink(this.folder, "prettify.js"));
    }

    @Override
    protected String getOnload() {
        return String.format("window['PR_TAB_WIDTH']=%d;prettyPrint()", this.tabWidth);
    }

    @Override
    protected String getFileName() {
        return String.valueOf(((ISourceFileCoverage)this.getNode()).getName()) + ".html";
    }
}

