/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.csv.DelimitedWriter;

class ClassRowWriter {
    private static final ICoverageNode.CounterEntity[] COUNTERS = new ICoverageNode.CounterEntity[]{ICoverageNode.CounterEntity.INSTRUCTION, ICoverageNode.CounterEntity.BRANCH, ICoverageNode.CounterEntity.LINE, ICoverageNode.CounterEntity.COMPLEXITY, ICoverageNode.CounterEntity.METHOD};
    private final DelimitedWriter writer;
    private final ILanguageNames languageNames;

    public ClassRowWriter(DelimitedWriter writer, ILanguageNames languageNames) throws IOException {
        this.writer = writer;
        this.languageNames = languageNames;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.writer.write("GROUP", "PACKAGE", "CLASS");
        ICoverageNode.CounterEntity[] counterEntityArray = COUNTERS;
        int n = COUNTERS.length;
        int n2 = 0;
        while (n2 < n) {
            ICoverageNode.CounterEntity entity = counterEntityArray[n2];
            this.writer.write(String.valueOf(entity.name()) + "_MISSED");
            this.writer.write(String.valueOf(entity.name()) + "_COVERED");
            ++n2;
        }
        this.writer.nextLine();
    }

    public void writeRow(String groupName, String packageName, IClassCoverage node) throws IOException {
        this.writer.write(groupName);
        this.writer.write(this.languageNames.getPackageName(packageName));
        String className = this.languageNames.getClassName(node.getName(), node.getSignature(), node.getSuperName(), node.getInterfaceNames());
        this.writer.write(className);
        ICoverageNode.CounterEntity[] counterEntityArray = COUNTERS;
        int n = COUNTERS.length;
        int n2 = 0;
        while (n2 < n) {
            ICoverageNode.CounterEntity entity = counterEntityArray[n2];
            ICounter counter = node.getCounter(entity);
            this.writer.write(counter.getMissedCount());
            this.writer.write(counter.getCoveredCount());
            ++n2;
        }
        this.writer.nextLine();
    }
}

