/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_kqcpih.core.instr;

import java.io.IOException;
import java.io.InputStream;
import org.jacoco.agent.rt_kqcpih.asm.ClassReader;
import org.jacoco.agent.rt_kqcpih.asm.ClassVisitor;
import org.jacoco.agent.rt_kqcpih.asm.ClassWriter;
import org.jacoco.agent.rt_kqcpih.core.internal.data.CRC64;
import org.jacoco.agent.rt_kqcpih.core.internal.flow.ClassProbesAdapter;
import org.jacoco.agent.rt_kqcpih.core.internal.instr.ClassInstrumenter;
import org.jacoco.agent.rt_kqcpih.core.runtime.IExecutionDataAccessorGenerator;

public class Instrumenter {
    private final IExecutionDataAccessorGenerator accessGenerator;

    public Instrumenter(IExecutionDataAccessorGenerator runtime) {
        this.accessGenerator = runtime;
    }

    private ClassVisitor createInstrumentingVisitor(long classid, ClassVisitor cv) {
        return new ClassProbesAdapter(new ClassInstrumenter(classid, this.accessGenerator, cv));
    }

    public byte[] instrument(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassVisitor visitor = this.createInstrumentingVisitor(CRC64.checksum(reader.b), writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }

    public byte[] instrument(byte[] buffer) {
        return this.instrument(new ClassReader(buffer));
    }

    public byte[] instrument(InputStream input) throws IOException {
        return this.instrument(new ClassReader(input));
    }
}

