/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_kqcpih.controller;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.jacoco.agent.rt_kqcpih.IExceptionLogger;
import org.jacoco.agent.rt_kqcpih.controller.IAgentController;
import org.jacoco.agent.rt_kqcpih.controller.TcpConnection;
import org.jacoco.agent.rt_kqcpih.core.runtime.AgentOptions;
import org.jacoco.agent.rt_kqcpih.core.runtime.IRuntime;

public class TcpServerController
implements IAgentController {
    private TcpConnection connection;
    private final IExceptionLogger logger;
    private ServerSocket serverSocket;
    private Thread worker;

    public TcpServerController(IExceptionLogger logger) {
        this.logger = logger;
    }

    public void startup(AgentOptions options, final IRuntime runtime) throws IOException {
        this.serverSocket = this.createServerSocket(options);
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!TcpServerController.this.serverSocket.isClosed()) {
                    try {
                        ServerSocket serverSocket = TcpServerController.this.serverSocket;
                        synchronized (serverSocket) {
                            TcpServerController.this.connection = new TcpConnection(TcpServerController.this.serverSocket.accept(), runtime);
                        }
                        TcpServerController.this.connection.init();
                        TcpServerController.this.connection.run();
                    }
                    catch (IOException e) {
                        if (TcpServerController.this.serverSocket.isClosed()) continue;
                        TcpServerController.this.logger.logExeption(e);
                    }
                }
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        this.serverSocket.close();
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.worker.join();
    }

    public void writeExecutionData() throws IOException {
        if (this.connection != null) {
            this.connection.writeExecutionData();
        }
    }

    protected ServerSocket createServerSocket(AgentOptions options) throws IOException {
        InetAddress inetAddr = this.getInetAddress(options.getAddress());
        return new ServerSocket(options.getPort(), 1, inetAddr);
    }

    protected InetAddress getInetAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            return null;
        }
        return InetAddress.getByName(address);
    }
}

