/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_jzhc14.core.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.agent.rt_jzhc14.core.data.ExecutionData;
import org.jacoco.agent.rt_jzhc14.core.data.IExecutionDataVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionDataStore
implements IExecutionDataVisitor {
    private final Map<Long, ExecutionData> entries = new HashMap<Long, ExecutionData>();

    public void put(ExecutionData data) throws IllegalStateException {
        Long id = data.getId();
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            this.entries.put(id, data);
        } else {
            entry.merge(data);
        }
    }

    public ExecutionData get(long id) {
        return this.entries.get(id);
    }

    public ExecutionData get(Long id, String name, int dataLength) {
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            entry = new ExecutionData((long)id, name, dataLength);
            this.entries.put(id, entry);
        } else {
            entry.assertCompatibility(id, name, dataLength);
        }
        return entry;
    }

    public void reset() {
        for (ExecutionData executionData : this.entries.values()) {
            executionData.reset();
        }
    }

    public Collection<ExecutionData> getContents() {
        return this.entries.values();
    }

    public void accept(IExecutionDataVisitor visitor) {
        for (ExecutionData data : this.entries.values()) {
            visitor.visitClassExecution(data);
        }
    }

    @Override
    public void visitClassExecution(ExecutionData data) {
        this.put(data);
    }
}

