/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Arrays;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfiguration;

public class SecurityConfigurationBuilder
implements Builder<SecurityConfiguration> {
    private final CredentialStoresConfigurationBuilder credentialStoresConfiguration;
    private final RealmsConfigurationBuilder realmsConfiguration = new RealmsConfigurationBuilder();
    private final ServerConfigurationBuilder builder;

    public SecurityConfigurationBuilder(ServerConfigurationBuilder builder) {
        this.builder = builder;
        this.credentialStoresConfiguration = new CredentialStoresConfigurationBuilder(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public CredentialStoresConfigurationBuilder credentialStores() {
        return this.credentialStoresConfiguration;
    }

    public RealmsConfigurationBuilder realms() {
        return this.realmsConfiguration;
    }

    public void validate() {
        Arrays.asList(this.credentialStoresConfiguration, this.realmsConfiguration).forEach(Builder::validate);
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.credentialStoresConfiguration.create(), this.realmsConfiguration.create(), this.builder.properties());
    }

    public SecurityConfigurationBuilder read(SecurityConfiguration template, Combine combine) {
        this.credentialStoresConfiguration.read(template.credentialStores(), combine);
        this.realmsConfiguration.read(template.realms(), combine);
        return this;
    }
}

