/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import org.infinispan.rest.framework.impl.PathItem;

class VariablePathItem
extends PathItem {
    private final String expression;
    private final String normalized;

    VariablePathItem(String expression) {
        this.expression = expression;
        this.normalized = VariablePathItem.normalize(expression);
    }

    String getExpression() {
        return this.expression;
    }

    private static String normalize(String expression) {
        if (expression == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean variable = false;
        for (char c : expression.toCharArray()) {
            if (!variable) {
                builder.append(c);
            }
            if (c == '{') {
                variable = true;
            }
            if (c != '}' || !variable) continue;
            variable = false;
            builder.append("}");
        }
        return builder.toString();
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariablePathItem that = (VariablePathItem)o;
        return this.normalized.equals(that.normalized);
    }

    public int hashCode() {
        return this.normalized.hashCode();
    }

    @Override
    public String getPath() {
        return this.expression;
    }
}

