/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.rest.configuration.CorsRuleConfiguration;

public class CorsConfiguration
extends ConfigurationElement<CorsConfiguration> {
    private final List<CorsConfig> nettyCorsConfigs;
    private final List<CorsRuleConfiguration> corsConfigurations;

    CorsConfiguration(List<CorsRuleConfiguration> corsConfigurations, List<CorsConfig> extraConfigs) {
        super("cors-rules", AttributeSet.EMPTY, CorsConfiguration.children(corsConfigurations));
        this.corsConfigurations = corsConfigurations;
        this.nettyCorsConfigs = corsConfigurations.stream().map(CorsRuleConfiguration::corsConfig).collect(Collectors.toList());
        this.nettyCorsConfigs.addAll(extraConfigs);
    }

    public List<CorsRuleConfiguration> corsRules() {
        return this.corsConfigurations;
    }

    List<CorsConfig> corsConfigs() {
        return Collections.unmodifiableList(this.nettyCorsConfigs);
    }
}

