/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.lang.reflect.Method;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.statetransfer.AbstractStateTransferTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.statetransfer.BackupForStateTransferTest")
public class BackupForStateTransferTest
extends AbstractStateTransferTest {
    private static final String VALUE = "value";
    private static final String LON_BACKUP_CACHE_NAME = "lonBackup";

    public BackupForStateTransferTest() {
        this.implicitBackupCache = false;
    }

    public void testStateTransferWithClusterIdle(Method method) {
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(LON_BACKUP_CACHE_NAME);
        this.assertNoStateTransferInSendingSite();
        int amountOfData = this.chunkSize() * 4;
        for (int i = 0; i < amountOfData; ++i) {
            this.cache("LON-1", 0).put((Object)TestingUtil.k(method, i), (Object)VALUE);
        }
        this.assertInSite("NYC-2", LON_BACKUP_CACHE_NAME, cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
        this.startStateTransfer();
        this.assertEventuallyStateTransferNotRunning();
        this.assertOnline("LON-1", "NYC-2");
        this.assertInSite("NYC-2", LON_BACKUP_CACHE_NAME, cache -> {
            for (int i = 0; i < amountOfData; ++i) {
                AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get((Object)TestingUtil.k(method, i)));
            }
        });
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
        this.assertEventuallyNoStateTransferInReceivingSite(LON_BACKUP_CACHE_NAME);
        this.assertNoStateTransferInSendingSite();
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return BackupForStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return BackupForStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
        builder.site("NYC-2").stateTransfer().chunkSize(10);
    }
}

