/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac.statetransfer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.statetransfer.IracStateTransferTest")
public class IracStateTransferTest
extends AbstractMultipleSitesTest {
    private final IracManagerHolder[] iracManagers = new IracManagerHolder[this.defaultNumberOfSites()];

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        builder.sites().addBackup().site(this.siteName(siteIndex == 0 ? 1 : 0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    @Override
    protected void afterSitesCreated() {
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            ArrayList<ManualIracManager> list = new ArrayList<ManualIracManager>(this.defaultNumberOfNodes());
            for (Cache cache : this.caches(this.siteName(i))) {
                list.add(ManualIracManager.wrapCache(cache));
            }
            this.iracManagers[i] = new IracManagerHolder(list);
        }
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() {
        super.createBeforeMethod();
        for (IracManagerHolder holder : this.iracManagers) {
            holder.iracManagers.forEach(m -> m.disable(ManualIracManager.DisableMode.DROP));
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        Arrays.fill(this.iracManagers, null);
    }

    public void testStateTransfer(Method method) {
        int keys = 8;
        this.assertOk(0, op -> op.takeSiteOffline(this.siteName(1)));
        this.assertStatus(0, 1, "offline");
        for (int i = 0; i < 8; ++i) {
            this.cache(0, 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, i));
        }
        this.assertKeys(method, 0, 0, 8);
        this.assertNoKeys(method, 1, 0, 8);
        this.iracManagers[0].iracManagers.forEach(ManualIracManager::enable);
        this.assertOk(0, op -> op.pushState(this.siteName(1)));
        this.assertStatus(0, 1, "online");
        AssertJUnit.assertEquals((String)"SENDING", (String)this.getPushStatus(0, 1));
        AssertJUnit.assertNull((Object)this.getSendingSiteName(1));
        this.iracManagers[0].iracManagers.forEach(m -> m.disable(ManualIracManager.DisableMode.SEND));
        this.waitStateTransfer(0, 1);
        this.assertKeys(method, 0, 0, 8);
        this.assertKeys(method, 1, 0, 8);
    }

    public void testConflict(Method method) {
        int i;
        this.assertOk(0, op -> op.takeSiteOffline(this.siteName(1)));
        this.assertOk(1, op -> op.takeSiteOffline(this.siteName(0)));
        this.assertStatus(0, 1, "offline");
        this.assertStatus(1, 0, "offline");
        for (i = 0; i < 4; ++i) {
            this.cache(0, 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, "site1", i));
        }
        this.assertKeys(method, 0, "site1", 0, 4);
        this.assertNoKeys(method, 1, 0, 4);
        for (i = 4; i < 8; ++i) {
            this.cache(0, 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, "site1", i));
            this.cache(1, 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, "site2", i));
        }
        this.assertKeys(method, 0, "site1", 0, 8);
        this.assertNoKeys(method, 1, 0, 4);
        this.assertKeys(method, 1, "site2", 4, 8);
        for (i = 8; i < 12; ++i) {
            this.cache(1, 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, "site2", i));
        }
        this.assertKeys(method, 0, "site1", 0, 8);
        this.assertNoKeys(method, 0, 8, 12);
        this.assertNoKeys(method, 1, 0, 4);
        this.assertKeys(method, 1, "site2", 4, 12);
        this.iracManagers[0].iracManagers.forEach(ManualIracManager::enable);
        this.assertOk(0, op -> op.pushState(this.siteName(1)));
        this.assertStatus(0, 1, "online");
        AssertJUnit.assertEquals((String)"SENDING", (String)this.getPushStatus(0, 1));
        AssertJUnit.assertNull((Object)this.getSendingSiteName(1));
        this.iracManagers[0].iracManagers.forEach(m -> m.disable(ManualIracManager.DisableMode.SEND));
        this.waitStateTransfer(0, 1);
        this.assertKeys(method, 0, "site1", 0, 8);
        this.assertNoKeys(method, 0, 8, 12);
        this.assertKeys(method, 1, "site1", 0, 8);
        this.assertKeys(method, 1, "site2", 8, 12);
        this.iracManagers[1].iracManagers.forEach(ManualIracManager::enable);
        this.assertOk(1, op -> op.pushState(this.siteName(0)));
        this.assertStatus(1, 0, "online");
        AssertJUnit.assertEquals((String)"SENDING", (String)this.getPushStatus(1, 0));
        AssertJUnit.assertNull((Object)this.getSendingSiteName(0));
        this.iracManagers[1].iracManagers.forEach(m -> m.disable(ManualIracManager.DisableMode.SEND));
        this.waitStateTransfer(1, 0);
        this.assertKeys(method, 0, "site1", 0, 8);
        this.assertKeys(method, 0, "site2", 8, 12);
        this.assertKeys(method, 1, "site1", 0, 8);
        this.assertKeys(method, 1, "site2", 8, 12);
    }

    private void assertStatus(int srcSite, int dstSite, String status) {
        this.assertInSite(this.siteName(srcSite), c -> AssertJUnit.assertEquals((String)status, (String)this.adminOperations(c).siteStatus(this.siteName(dstSite))));
    }

    private void assertNoKeys(Method method, int srcSite, int startKey, int endKey) {
        this.assertInSite(this.siteName(srcSite), cache -> {
            for (int i = startKey; i < endKey; ++i) {
                AssertJUnit.assertNull((Object)cache.get((Object)TestingUtil.k(method, i)));
            }
        });
    }

    private void assertKeys(Method method, int srcSite, String prefix, int startKey, int endKey) {
        this.assertInSite(this.siteName(srcSite), cache -> {
            for (int i = startKey; i < endKey; ++i) {
                AssertJUnit.assertEquals((Object)TestingUtil.v(method, prefix, i), (Object)cache.get((Object)TestingUtil.k(method, i)));
            }
        });
    }

    private void assertKeys(Method method, int srcSite, int startKey, int endKey) {
        this.assertInSite(this.siteName(srcSite), cache -> {
            for (int i = startKey; i < endKey; ++i) {
                AssertJUnit.assertEquals((Object)TestingUtil.v(method, i), (Object)cache.get((Object)TestingUtil.k(method, i)));
            }
        });
    }

    private void assertOk(int siteIndex, Function<XSiteAdminOperations, String> f) {
        AssertJUnit.assertEquals((String)"ok", (String)f.apply(this.adminOperations(siteIndex)));
    }

    private void waitStateTransfer(int srcSite, int dstSite) {
        IracStateTransferTest.eventually(() -> "Expected <ok> but was " + this.getPushStatus(srcSite, dstSite), () -> "OK".equals(this.getPushStatus(srcSite, dstSite)));
    }

    private String getPushStatus(int srcSite, int dstSite) {
        return (String)this.adminOperations(srcSite).getPushStateStatus().get(this.siteName(dstSite));
    }

    private String getSendingSiteName(int dstSite) {
        return this.adminOperations(dstSite).getSendingSiteName();
    }

    private XSiteAdminOperations adminOperations(int siteIndex) {
        return this.adminOperations(this.cache(siteIndex, 0));
    }

    private XSiteAdminOperations adminOperations(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, XSiteAdminOperations.class);
    }

    private static class IracManagerHolder {
        private final List<ManualIracManager> iracManagers;

        private IracManagerHolder(List<ManualIracManager> iracManagers) {
            this.iracManagers = iracManagers;
        }
    }
}

