/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac.persistence;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.KeyValueWrapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.support.WaitNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.XSiteNamedCache;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseIracPersistenceTest<V>
extends SingleCacheManagerTest {
    private static final AtomicLong V_GENERATOR = new AtomicLong();
    private static final String SITE = "LON";
    private final KeyValueWrapper<String, String, V> keyValueWrapper;
    protected String tmpDirectory;
    protected WaitNonBlockingStore<String, V> cacheStore;
    protected int segmentCount;
    protected MarshallableEntryFactory<String, V> entryFactory;

    protected BaseIracPersistenceTest(KeyValueWrapper<String, String, V> keyValueWrapper) {
        this.keyValueWrapper = keyValueWrapper;
    }

    public void testWriteAndPublisher(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        IracMetadata metadata = BaseIracPersistenceTest.createMetadata();
        this.cacheStore.write(this.createEntry(key, value, metadata));
        MarshallableEntrySubscriber subscriber = new MarshallableEntrySubscriber();
        this.cacheStore.publishEntries(IntSets.immutableRangeSet((int)this.segmentCount), key::equals, true).subscribe(subscriber);
        List entries = subscriber.cf.join();
        AssertJUnit.assertEquals((int)1, (int)entries.size());
        this.assertCorrectEntry(entries.get(0), key, value, metadata);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gBuilder = this.createGlobalConfigurationBuilder();
        ConfigurationBuilder cBuilder = new ConfigurationBuilder();
        this.configure(cBuilder);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(gBuilder, cBuilder);
        this.cacheStore = TestingUtil.getFirstStoreWait(cm.getCache());
        this.segmentCount = cm.getCache().getCacheConfiguration().clustering().hash().numSegments();
        this.entryFactory = TestingUtil.extractComponent(cm.getCache(), MarshallableEntryFactory.class);
        return cm;
    }

    @Override
    protected void teardown() {
        super.teardown();
        this.cacheStore = null;
        this.entryFactory = null;
    }

    protected abstract void configure(ConfigurationBuilder var1);

    public void testWriteAndLoad(Method method) {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        IracMetadata metadata = BaseIracPersistenceTest.createMetadata();
        this.cacheStore.write(this.createEntry(key, value, metadata));
        MarshallableEntry<String, V> loadedMEntry = this.cacheStore.loadEntry(key);
        this.assertCorrectEntry(loadedMEntry, key, value, metadata);
    }

    private GlobalConfigurationBuilder createGlobalConfigurationBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().nonClusteredDefault();
        builder.globalState().persistentLocation(this.tmpDirectory);
        builder.serialization().addContextInitializer(this.getSerializationContextInitializer());
        return builder;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    protected void createBeforeClass() throws Exception {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        Util.recursiveFileRemove((String)this.tmpDirectory);
        boolean created = new File(this.tmpDirectory).mkdirs();
        log.debugf("Created temporary directory %s (exists? %s)", (Object)this.tmpDirectory, (Object)(!created ? 1 : 0));
        super.createBeforeClass();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected SerializationContextInitializer getSerializationContextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    private void assertCorrectEntry(MarshallableEntry<String, V> entry, String key, String value, IracMetadata metadata) {
        AssertJUnit.assertNotNull(entry);
        AssertJUnit.assertEquals((String)key, (String)((String)entry.getKey()));
        AssertJUnit.assertEquals((String)value, (String)this.keyValueWrapper.unwrap(entry.getValue()));
        PrivateMetadata internalMetadata = entry.getInternalMetadata();
        AssertJUnit.assertNotNull((Object)internalMetadata);
        IracMetadata storedMetadata = entry.getInternalMetadata().iracMetadata();
        AssertJUnit.assertEquals((Object)metadata, (Object)storedMetadata);
    }

    private MarshallableEntry<String, V> createEntry(String key, String value, IracMetadata metadata) {
        return this.entryFactory.create((Object)key, this.keyValueWrapper.wrap(key, value), null, BaseIracPersistenceTest.wrapInternalMetadata(metadata), -1L, -1L);
    }

    private static IracMetadata createMetadata() {
        TopologyIracVersion version = TopologyIracVersion.create((int)1, (long)V_GENERATOR.incrementAndGet());
        ByteString site = XSiteNamedCache.cachedByteString((String)SITE);
        return new IracMetadata(site, IracEntryVersion.newVersion((ByteString)site, (TopologyIracVersion)version));
    }

    private static PrivateMetadata wrapInternalMetadata(IracMetadata metadata) {
        return new PrivateMetadata.Builder().iracMetadata(metadata).build();
    }

    private static class MarshallableEntrySubscriber<V>
    implements Subscriber<MarshallableEntry<String, V>> {
        @GuardedBy(value="this")
        private final List<MarshallableEntry<String, V>> entries = new ArrayList<MarshallableEntry<String, V>>(1);
        private final CompletableFuture<List<MarshallableEntry<String, V>>> cf = new CompletableFuture();

        private MarshallableEntrySubscriber() {
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public synchronized void onNext(MarshallableEntry<String, V> entry) {
            this.entries.add(entry);
        }

        public void onError(Throwable throwable) {
            this.cf.completeExceptionally(throwable);
        }

        public synchronized void onComplete() {
            this.cf.complete(this.entries);
        }
    }
}

